/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.logging.Logger;

public class FitsHeadersSpecificationsBuilder {
    private final Map<String, HeaderSpecification> headerSpecificationsMap = new HashMap<String, HeaderSpecification>();
    public static final Logger log = Logger.getLogger((String)"org.lsst.ccs.utilities.image");

    public final void addSpecFile(String fileName) {
        this.readHeaderSpecification(fileName, null);
    }

    public final void addSpecFile(String fileName, String headerName) {
        this.readHeaderSpecification(fileName, headerName);
    }

    public final Map<String, HeaderSpecification> getHeaderSpecifications() {
        return Collections.unmodifiableMap(this.headerSpecificationsMap);
    }

    private void readHeaderSpecification(String name, String headerName) throws RuntimeException {
        String fileName;
        String string = fileName = name.endsWith(".spec") ? name : name + ".spec";
        if (headerName == null) {
            headerName = fileName.replace(".spec", "");
        }
        try (InputStream bootstrapResource = BootstrapResourceUtils.getBootstrapResource((String)fileName);){
            if (bootstrapResource == null) {
                log.severe((Object)("Failed to open spec file " + fileName));
                return;
            }
            HeaderSpecification desc = null;
            if (this.headerSpecificationsMap.containsKey(headerName)) {
                desc = this.headerSpecificationsMap.get(headerName);
                desc.loadHeaderSpecification(bootstrapResource);
            } else {
                desc = new HeaderSpecification(headerName, bootstrapResource);
                this.headerSpecificationsMap.put(headerName, desc);
            }
        }
        catch (IOException x) {
            throw new RuntimeException("Error reading " + fileName, x);
        }
    }
}

