/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapPage;

public final class FocalPlaneMapPageDialog
extends JDialog {
    private FocalPlaneMapPage.Descriptor out;
    private JTextField titleField;
    private SpinnerNumberModel rowsSpinner;
    private SpinnerNumberModel columnsSpinner;

    private FocalPlaneMapPageDialog(Component parentComponent, String defaultTitle) {
        super(parentComponent == null ? null : SwingUtilities.getWindowAncestor(parentComponent), "Open new focal plane map page", Dialog.ModalityType.APPLICATION_MODAL);
        Box panel = Box.createVerticalBox();
        this.add((Component)panel, "Center");
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        Box box = Box.createHorizontalBox();
        panel.add(box);
        box.add(new JLabel("Title:"));
        box.add(Box.createRigidArea(Const.HDIM));
        this.titleField = new JTextField(defaultTitle, 20);
        box.add(this.titleField);
        box.add(Box.createHorizontalGlue());
        panel.add(Box.createRigidArea(Const.VDIM));
        box = Box.createHorizontalBox();
        panel.add(box);
        box.add(new JLabel("Rows:"));
        box.add(Box.createRigidArea(Const.HDIM));
        this.rowsSpinner = new SpinnerNumberModel(1, 1, 16, 1);
        box.add(new Spinner(this.rowsSpinner));
        box.add(Box.createRigidArea(new Dimension(30, 0)));
        box.add(new JLabel("Columns:"));
        box.add(Box.createRigidArea(Const.HDIM));
        this.columnsSpinner = new SpinnerNumberModel(1, 1, 16, 1);
        box.add(new Spinner(this.columnsSpinner));
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(Box.createHorizontalGlue());
        panel.add(Box.createVerticalGlue());
        box = Box.createHorizontalBox();
        this.add((Component)box, "South");
        box.add(Box.createHorizontalGlue());
        JButton okButton = new JButton(" OK ");
        box.add(okButton);
        okButton.addActionListener(e -> {
            this.out = new FocalPlaneMapPage.Descriptor();
            this.out.setName(this.titleField.getText());
            this.out.setRows(this.rowsSpinner.getNumber().intValue());
            this.out.setColumns(this.columnsSpinner.getNumber().intValue());
            this.dispose();
        });
    }

    public static FocalPlaneMapPage.Descriptor show(Component parentComponent, String defaultTitle) {
        if (parentComponent == null) {
            parentComponent = Console.getConsole().getWindow();
        }
        FocalPlaneMapPageDialog dialog = new FocalPlaneMapPageDialog(parentComponent, defaultTitle);
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.setVisible(true);
        return dialog.out;
    }

    private static class Spinner
    extends JSpinner {
        public Spinner(SpinnerModel model) {
            super(model);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

