package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.io.Serializable;
import java.util.*;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.util.session.Savable;

/**
 * {@link AgentChannelsFilter} based on a list of {@link Template}s.
 * To be used by {@link FocalPlaneMapView}.
 *
 * @author onoprien
 */
public class TemplateFilter extends AbstractChannelsFilter implements Savable {

// -- Fields : -----------------------------------------------------------------
    
    private final Descriptor descriptor;
    private final ArrayList<Template> templates;
    
    private final HashSet<String> accept = new HashSet<>();
    private final HashSet<String> reject = new HashSet<>();

// -- Life cycle : -------------------------------------------------------------
    
    public TemplateFilter(Descriptor descriptor) {
        this.descriptor = descriptor;
        String[] tt = descriptor.getTemplates();
        templates = new ArrayList<>(tt.length);
        for (String s : tt) {
            templates.add(Template.valueOf(s));
        }
    }
    
    public TemplateFilter(String title, List<Template> templates, Segment granularity) {
        descriptor = new Descriptor();
        descriptor.setTitle(title);
        String[] tt = new String[templates.size()];
        int i=0;
        for (Template template : templates) {
            tt[i++] = template.toString();
        }
        descriptor.setTemplates(tt);
        this.templates = new ArrayList<>(templates);
    }
    
// -- Implementing AgentChannelsFilter : ---------------------------------------
    
    @Override
    public String getName() {
        return descriptor.getTitle();
    }

    @Override
    public List<String> getAgents() {
        LinkedHashSet<String> aa = new LinkedHashSet<>(descriptor.getTemplates().length * 2);
        for (Template t : templates) {
            aa.add(t.code.substring(0, t.code.indexOf("/")));
        }
        return new ArrayList<>(aa);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return displayPath;
    }

    @Override
    public List<String> getDisplayPath(AgentChannel channel) {
        if (channel == null) return Collections.emptyList();
        String path = channel.getPath();
        if (accept.contains(path)) return Collections.singletonList(path);
        if (reject.contains(path)) return Collections.emptyList();
        Template t = Template.valueOf(channel);
        if (templates.contains(t)) {
            accept.add(path);
            return Collections.singletonList(path);
        } else {
            reject.add(path);
            return Collections.emptyList();
        }
    }
    

// -- Saving : -----------------------------------------------------------------

//    @Override
//    public Descriptor save() {
//        return descriptor;
//    }
    
    static public class Descriptor implements Serializable {

        private String granularity;
        private String[] templates;
        private String title;

        public String getGranularity() {
            return granularity;
        }

        public void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        public String[] getTemplates() {
            return templates;
        }

        public void setTemplates(String[] templates) {
            this.templates = templates;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

    }


}
