package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.io.Serializable;

/**
 * Implemented by classes that describe the content of a {@link FocalPlaneMap}.
 *
 * @author onoprien
 */
public interface FocalPlaneMapModelFactory {
    
    /**
     * Returns a human-readable name of this factory.
     * The name should be unique.
     * 
     * @return Factory name.
     */
    @Override
    String toString();
    
    /**
     * Creates a model based on the specified descriptor.
     * 
     * @param descriptor Model descriptor, or {@code null} if the default model should be created.
     * @return Model.
     */
    FocalPlaneMapModel getModel(Serializable descriptor);
    
    default FocalPlaneMapModel createModel(Serializable descriptor) {
        return getModel(descriptor);
    }
    
    default void start(FocalPlaneMapModel model) {}
    
    default void stop(FocalPlaneMapModel model) {}
    
}
