package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.Color;
import java.io.Serializable;
import java.util.Random;

/**
 * 
 *
 * @author onoprien
 */
public class FakeModel3 extends AbstractFocalPlaneMapModel implements FocalPlaneMapModelFactory {

// -- Fields : -----------------------------------------------------------------
    
    private String name;
    static private Random random = new Random();

// -- Life cycle : -------------------------------------------------------------
    
    public FakeModel3(String name) {
        this.name = name;
    }
    
// -- Implementing FocalPlaneMapModelFactory : ---------------------------------

    @Override
    public String toString() {
        return name;
    }

    @Override
    public FocalPlaneMapModel getModel(Serializable descriptor) {
        return this;
    }

// -- Model : ------------------------------------------------------------------
    
    @Override
    public FocalPlaneMapValue getValue() {
        FocalPlaneMapValue v = new FocalPlaneMapValue();
        v.bgColor = Color.BLACK;
        v.toolTip = "Default";
        return v;
    }

    @Override
    public FocalPlaneMapValue getValue(int raftX, int raftY) {
        CCDType type = FocalPlane.getType(raftX, raftY);
        if (type == CCDType.SCIENCE) {
            FocalPlaneMapValue v;
            switch (raftX) {
                case 0:
                    v = new FocalPlaneMapValue();
                    v.bgColor = Color.GREEN;
                    return v;
                case 1:
                    return FocalPlaneMapValue.NONE;
                case 2:
                    return null;
                default:
                    v = new FocalPlaneMapValue();
                    v.bgColor = Color.MAGENTA;
                    v.setSplit(true);
                    return v;
            }
        } else {
            return FocalPlaneMapValue.EMPTY;
        }
    }

    @Override
    public FocalPlaneMapValue getValue(int raftX, int raftY, int reb) {
        FocalPlaneMapValue v;
        switch (reb) {
            case 0:
                v = new FocalPlaneMapValue();
                v.bgColor = Color.RED;
                return v;
            case 1:
                v = new FocalPlaneMapValue();
                v.bgColor = Color.blue;
                v.setSplit(true);
                return v;
            default:
                return raftX == 3 ? null : FocalPlaneMapValue.NONE;
        }
    }

    @Override
    public FocalPlaneMapValue getValue(int raftX, int raftY, int reb, int ccdY) {
        FocalPlaneMapValue v;
        switch (ccdY) {
            case 0:
                v = new FocalPlaneMapValue();
                v.bgColor = Color.YELLOW;
                return v;
            case 1:
                v = new FocalPlaneMapValue();
                v.bgColor = Color.PINK;
                v.setSplit(true);
                return v;
            default:
                return FocalPlaneMapValue.NONE;
        }
    }
    
    @Override
    public FocalPlaneMapValue getValue(int raftX, int raftY, int reb, int ccdY, int ampX, int ampY) {
        if (ampX % 2 == 0) {
            return null;
        } else {
            if (ampY % 2 == 0) {
                FocalPlaneMapValue v = new FocalPlaneMapValue();
                v.bgColor = Color.ORANGE;
                return v;
            } else {
                return null;
            }
        }
    }

}
