package org.lsst.ccs.subsystem.focalplane.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.gconsole.agent.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.subsystem.focalplane.data.FocalPlaneDataGroup;

/**
 * Rafts monitoring filter.
 *
 * @author The LSST CCS Team
 */
@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter",
               name="FocalPlane monitor filter",
               path="Subsystems/FocalPlane/Monitor",
               description="FocalPlane subsystem monitor filter.")
public class FocalPlaneMonitorFilter extends AbstractChannelsFilter {

    private final FocalPlaneDataGroup dataGroup;
    private String agentName;

    public final static List<String> FIELDS = new ArrayList<>();
    static {
        FIELDS.add(MonitorField.VALUE.getKey());
        FIELDS.add(MonitorField.UNITS.getKey());
        FIELDS.add(MonitorField.LOW_ALARM.getKey());
        FIELDS.add(MonitorField.LOW_WARN.getKey());
        FIELDS.add(MonitorField.ALERT_LOW.getKey());
        FIELDS.add(MonitorField.HIGH_WARN.getKey());
        FIELDS.add(MonitorField.HIGH_ALARM.getKey());
        FIELDS.add(MonitorField.ALERT_HIGH.getKey());
        FIELDS.add(MonitorField.NAME.getKey());
        FIELDS.add(MonitorField.DESCR.getKey());
                
    }

    public FocalPlaneMonitorFilter(String agents, FocalPlaneDataGroup dataGroup) {
        this.dataGroup = dataGroup;
        this.agentName = (agents == null || agents.isEmpty()) ? null : agents;
    }

    @Override
    public String getName() {
        return "FP:"+ dataGroup;
    }
    
    @Override
    public List<String> getAgents() {
        return agentName == null ? null : Collections.singletonList(agentName);
    }

    @Override
    public List<String> getFields(boolean compact) {
        return FIELDS;
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList("agent."+DataProviderInfo.Attribute.DATA_GROUP.getName()+"="+dataGroup.getName());
    }
    
    @Override
    public List<String> getDisplayPath(String originPath) {
        int i = originPath.indexOf("/");
        if (agentName == null) {
            agentName = originPath.substring(0,i);
        }
        return Collections.singletonList(originPath.substring(i+1));
    }

    @Override
    public String getOriginPath(String displayPath) {
        return agentName +"/"+ displayPath;
    }
    
}
