/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.demo.monitor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;

public class TradMonitorPanel
extends JPanel {
    static final Font f = new Font("Tahoma", 1, 12);
    static final Color RED = new Color(150, 0, 0);
    static final Color GREEN = new Color(0, 150, 0);
    private final CommandSender gui;
    private String mainName;
    private double mainPeriod = 5.0;
    private JLabel lbMainPeriod;
    private JLabel lbMainPeriodUnits;
    private JLabel lbMainState;
    private JLabel lbMainStateValue;
    private JTextField tfMainPeriod;
    private static final long serialVersionUID = 1L;

    public TradMonitorPanel(CommandSender gui) {
        this.gui = gui;
        this.initComponents();
        this.lbMainState.setFont(f);
        this.lbMainStateValue.setFont(f);
        this.lbMainPeriod.setFont(f);
        this.lbMainPeriodUnits.setFont(f);
        new UpdateRaftsStatus(0, null).run();
        new DisableSystem(0).run();
    }

    public void setSubsystem(String mainName) {
        this.mainName = mainName;
    }

    private void initComponents() {
        this.lbMainState = new JLabel();
        this.lbMainPeriod = new JLabel();
        this.lbMainStateValue = new JLabel();
        this.tfMainPeriod = new JTextField();
        this.lbMainPeriodUnits = new JLabel();
        this.lbMainState.setText("Rafts State:");
        this.lbMainState.setHorizontalTextPosition(10);
        this.lbMainPeriod.setText("Update Period:");
        this.lbMainStateValue.setText("....");
        this.tfMainPeriod.setText("...");
        this.tfMainPeriod.setMinimumSize(new Dimension(50, 19));
        this.tfMainPeriod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TradMonitorPanel.this.tfMainPeriodActionPerformed(evt);
            }
        });
        this.lbMainPeriodUnits.setText("sec");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(257, Short.MAX_VALUE).addComponent(this.lbMainState).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lbMainStateValue, -2, 72, -2).addGap(90, 90, 90).addComponent(this.lbMainPeriod).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfMainPeriod, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbMainPeriodUnits).addContainerGap(246, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbMainStateValue).addComponent(this.lbMainState).addComponent(this.lbMainPeriod, -2, 25, -2).addComponent(this.tfMainPeriod, -2, -1, -2).addComponent(this.lbMainPeriodUnits)).addContainerGap(71, Short.MAX_VALUE)));
    }

    private void tfMainPeriodActionPerformed(ActionEvent evt) {
        try {
            double value = Double.valueOf(this.tfMainPeriod.getText());
            this.gui.sendCommand(this.mainName, null, "setUpdatePeriod", (int)(1000.0 * value));
            this.tfMainPeriod.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.tfMainPeriod.setText(String.valueOf(this.mainPeriod));
        }
    }

    public void updateControlPanel(int id, MonitorState rs) {
        SwingUtilities.invokeLater(new UpdateRaftsStatus(id, rs));
    }

    public void disableSystem(int id) {
        SwingUtilities.invokeLater(new DisableSystem(id));
    }

    class DisableSystem
    implements Runnable {
        private final int id;

        DisableSystem(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            if (this.id == 0) {
                TradMonitorPanel.this.lbMainStateValue.setText("STOPPED");
                TradMonitorPanel.this.lbMainStateValue.setForeground(RED);
                TradMonitorPanel.this.tfMainPeriod.setEnabled(false);
            }
        }
    }

    class UpdateRaftsStatus
    implements Runnable {
        private final int id;
        private final MonitorState rs;

        UpdateRaftsStatus(int id, MonitorState rs) {
            this.id = id;
            this.rs = rs;
        }

        @Override
        public void run() {
            if (this.id == 0) {
                TradMonitorPanel.this.lbMainStateValue.setText("RUNNING");
                TradMonitorPanel.this.lbMainStateValue.setForeground(GREEN);
                TradMonitorPanel.this.tfMainPeriod.setEnabled(true);
                TradMonitorPanel.this.mainPeriod = 5.0;
                TradMonitorPanel.this.tfMainPeriod.setText(String.valueOf(TradMonitorPanel.this.mainPeriod));
            }
        }
    }
}

