/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JPanel;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapModel;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapModelEvent;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapModelListener;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapValue;
import org.python.bouncycastle.util.Arrays;

public final class FocalPlaneMap
extends JPanel {
    private Descriptor descriptor;
    private FocalPlaneMapModel model;
    private final FocalPlaneMapModelListener modelListener = this::onModelEvent;
    private int sizeLimit;
    private int size;
    private int x0;
    private int y0;
    private int ccdLineWidth;
    private int raftLineWidth;
    private int raftSize;
    private int ccdSize;
    private int ampWidth;
    private int ampHeight;
    private final int[] currentCell = new int[6];
    private FocalPlaneMapValue currentValue;

    public FocalPlaneMap() {
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setToolTipText("super");
        Arrays.fill((int[])this.currentCell, (int)-1);
    }

    public void setModel(FocalPlaneMapModel model) {
        if (this.model != null) {
            this.model.removeFocalPlaneMapModelListener(this.modelListener);
        }
        this.model = model;
        if (model == null) {
            this.setName("");
        } else {
            model.addFocalPlaneMapModelListener(this.modelListener);
            this.setName(model.getTitle());
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        FocalPlaneMapValue def;
        super.paintComponent(g);
        Dimension dim = this.getSize();
        int newSize = Math.min(dim.width, dim.height);
        if (newSize != this.sizeLimit) {
            this.sizeLimit = newSize;
            this.ccdLineWidth = Math.max(this.sizeLimit / 200, 1);
            this.raftLineWidth = this.ccdLineWidth * 2;
            this.ccdSize = (this.sizeLimit - this.raftLineWidth * 6 - this.ccdLineWidth * 10) / 15;
            this.ampWidth = this.ccdSize / 2;
            this.ccdSize = this.ampWidth * 2;
            this.ampHeight = this.ccdSize / 8;
            this.raftSize = this.ccdSize * 3 + this.ccdLineWidth * 2;
            this.size = this.raftSize * 5 + this.raftLineWidth * 6;
            this.x0 = (dim.width - this.size) / 2;
            this.y0 = (dim.height - this.size) / 2;
        }
        FocalPlaneMapValue focalPlaneMapValue = def = this.model == null ? FocalPlaneMapValue.EMPTY : this.model.getValue();
        if (def == null) {
            def = FocalPlaneMapValue.EMPTY;
        }
        for (int raftX = 0; raftX < 5; ++raftX) {
            for (int raftY = 0; raftY < 5; ++raftY) {
                int[] yy;
                FocalPlaneMapValue raftValue;
                int xRaftPos = this.x0 + (4 - raftX) * (this.raftSize + this.raftLineWidth) + this.raftLineWidth;
                int yRaftPos = this.y0 + (4 - raftY) * (this.raftSize + this.raftLineWidth) + this.raftLineWidth;
                FocalPlaneMapValue focalPlaneMapValue2 = raftValue = this.model == null ? FocalPlaneMapValue.EMPTY : this.model.getValue(raftX, raftY);
                if (raftValue != null && raftValue.isSplit()) {
                    if (raftValue == FocalPlaneMapValue.NONE) {
                        raftValue = def;
                    }
                    for (int reb = 0; reb < 3; ++reb) {
                        int xRebPos = xRaftPos + (2 - reb) * (this.ccdSize + this.ccdLineWidth);
                        FocalPlaneMapValue rebValue = this.model.getValue(raftX, raftY, reb);
                        if (rebValue != null && rebValue.isSplit()) {
                            if (rebValue == FocalPlaneMapValue.NONE) {
                                rebValue = raftValue;
                            }
                            for (int ccdY = 0; ccdY < 3; ++ccdY) {
                                int yCcdPos = yRaftPos + (2 - ccdY) * (this.ccdSize + this.ccdLineWidth);
                                if (!this.isValid(raftX, raftY, reb, ccdY)) continue;
                                FocalPlaneMapValue ccdValue = this.model.getValue(raftX, raftY, reb, ccdY);
                                if (ccdValue != null && ccdValue.isSplit()) {
                                    if (ccdValue == FocalPlaneMapValue.NONE) {
                                        ccdValue = rebValue;
                                    }
                                    for (int ampX = 0; ampX < 2; ++ampX) {
                                        int xAmpPos = xRebPos + this.ampWidth * (1 - ampX);
                                        for (int ampY = 0; ampY < 8; ++ampY) {
                                            int yAmpPos = yCcdPos + this.ampHeight * (7 - ampY);
                                            FocalPlaneMapValue ampValue = this.model.getValue(raftX, raftY, reb, ccdY, ampX, ampY);
                                            if (ampValue == null || ampValue == FocalPlaneMapValue.NONE) {
                                                ampValue = ccdValue;
                                            }
                                            g.setColor(ampValue.getColor());
                                            g.fillRect(xAmpPos, yAmpPos, this.ampWidth, this.ampHeight);
                                        }
                                    }
                                    continue;
                                }
                                if (ccdValue == null) {
                                    ccdValue = rebValue;
                                }
                                g.setColor(ccdValue.getColor());
                                g.fillRect(xRebPos, yCcdPos, this.ccdSize, this.ccdSize);
                            }
                            continue;
                        }
                        if (rebValue == null) {
                            rebValue = raftValue;
                        }
                        g.setColor(rebValue.getColor());
                        g.fillRect(xRebPos, yRaftPos, this.ccdSize, this.raftSize);
                    }
                    continue;
                }
                if (raftValue == null) {
                    raftValue = def;
                }
                g.setColor(raftValue.getColor());
                if (raftX == 4 && raftY == 0) {
                    int[] xx = new int[]{xRaftPos + this.ccdSize + this.ccdLineWidth, xRaftPos + this.raftSize, xRaftPos + this.raftSize, xRaftPos + this.raftSize - this.ccdSize, xRaftPos + this.raftSize - this.ccdSize, xRaftPos + this.ccdSize + this.ccdLineWidth};
                    yy = new int[]{yRaftPos, yRaftPos, yRaftPos + 2 * this.ccdSize + this.ccdLineWidth, yRaftPos + 2 * this.ccdSize + this.ccdLineWidth, yRaftPos + this.ccdSize, yRaftPos + this.ccdSize};
                    g.fillPolygon(xx, yy, 6);
                    continue;
                }
                if (raftX == 4 && raftY == 4) {
                    int[] xx = new int[]{xRaftPos + this.ccdSize + this.ccdLineWidth, xRaftPos + this.raftSize, xRaftPos + this.raftSize, xRaftPos + this.raftSize - this.ccdSize, xRaftPos + this.raftSize - this.ccdSize, xRaftPos + this.ccdSize + this.ccdLineWidth};
                    yy = new int[]{yRaftPos + this.raftSize, yRaftPos + this.raftSize, yRaftPos + this.ccdSize + this.ccdLineWidth, yRaftPos + this.ccdSize + this.ccdLineWidth, yRaftPos + this.raftSize - this.ccdSize, yRaftPos + this.raftSize - this.ccdSize};
                    g.fillPolygon(xx, yy, 6);
                    continue;
                }
                if (raftX == 0 && raftY == 0) {
                    int[] xx = new int[]{xRaftPos + 2 * this.ccdSize + this.ccdLineWidth, xRaftPos, xRaftPos, xRaftPos + this.ccdSize, xRaftPos + this.ccdSize, xRaftPos + 2 * this.ccdSize + this.ccdLineWidth};
                    yy = new int[]{yRaftPos, yRaftPos, yRaftPos + 2 * this.ccdSize + this.ccdLineWidth, yRaftPos + 2 * this.ccdSize + this.ccdLineWidth, yRaftPos + this.ccdSize, yRaftPos + this.ccdSize};
                    g.fillPolygon(xx, yy, 6);
                    continue;
                }
                if (raftX == 0 && raftY == 4) {
                    int[] xx = new int[]{xRaftPos + 2 * this.ccdSize + this.ccdLineWidth, xRaftPos, xRaftPos, xRaftPos + this.ccdSize, xRaftPos + this.ccdSize, xRaftPos + 2 * this.ccdSize + this.ccdLineWidth};
                    yy = new int[]{yRaftPos + this.raftSize, yRaftPos + this.raftSize, yRaftPos + this.ccdSize + this.ccdLineWidth, yRaftPos + this.ccdSize + this.ccdLineWidth, yRaftPos + this.raftSize - this.ccdSize, yRaftPos + this.raftSize - this.ccdSize};
                    g.fillPolygon(xx, yy, 6);
                    continue;
                }
                g.fillRect(xRaftPos, yRaftPos, this.raftSize, this.raftSize);
            }
        }
    }

    private boolean isValid(int raftX, int raftY, int ccdX, int ccdY) {
        switch (raftX) {
            case 0: {
                switch (raftY) {
                    case 0: {
                        return ccdX + ccdY > 2;
                    }
                    case 4: {
                        return ccdX > ccdY;
                    }
                }
                return true;
            }
            case 4: {
                switch (raftY) {
                    case 0: {
                        return ccdY > ccdX;
                    }
                    case 4: {
                        return ccdX + ccdY < 2;
                    }
                }
                return true;
            }
        }
        return true;
    }

    private void onModelEvent(FocalPlaneMapModelEvent event) {
        this.repaint();
    }

    private void setCurrentCell(int x, int y) {
        int ccdY;
        this.clearCurrentCell();
        if (this.model == null || this.size == 0) {
            return;
        }
        x = this.x0 + this.size - (x + this.raftLineWidth);
        y = this.y0 + this.size - (y + this.raftLineWidth);
        if (x < 0 || y < 0) {
            return;
        }
        int s = this.raftSize + this.raftLineWidth;
        int raftX = x / s;
        if (raftX > 4) {
            return;
        }
        int raftY = y / s;
        if (raftX > 4) {
            return;
        }
        if ((x -= s * raftX) >= this.raftSize || (y -= s * raftY) >= this.raftSize) {
            return;
        }
        if (raftX == 0 || raftX == 4) {
            // empty if block
        }
        this.currentCell[0] = raftX;
        this.currentCell[1] = raftY;
        this.currentValue = this.model.getValue(raftX, raftY);
        if (this.currentValue == null) {
            this.currentValue = this.model.getValue();
            return;
        }
        if (this.currentValue == FocalPlaneMapValue.NONE) {
            this.currentValue = this.model.getValue();
        } else if (!this.currentValue.isSplit()) {
            return;
        }
        s = this.ccdSize + this.ccdLineWidth;
        int reb = x / s;
        if ((x -= reb * s) >= this.ccdSize || reb < 0 || reb > 2) {
            this.clearCurrentCell();
            return;
        }
        this.currentCell[2] = reb;
        FocalPlaneMapValue v = this.model.getValue(raftX, raftY, reb);
        if (v == null) {
            return;
        }
        if (v != FocalPlaneMapValue.NONE) {
            if (v.isSplit()) {
                this.currentValue = v;
            } else {
                this.currentValue = v;
                return;
            }
        }
        if ((y -= (ccdY = y / s) * s) >= this.ccdSize || ccdY < 0 || ccdY > 2) {
            this.clearCurrentCell();
            return;
        }
        this.currentCell[3] = ccdY;
        v = this.model.getValue(raftX, raftY, reb, ccdY);
        if (v == null) {
            return;
        }
        if (v != FocalPlaneMapValue.NONE) {
            if (v.isSplit()) {
                this.currentValue = v;
            } else {
                this.currentValue = v;
                return;
            }
        }
        int ampX = x / this.ampWidth;
        int ampY = (y -= this.ccdSize - this.ampHeight * 8) / this.ampHeight;
        if (ampX < 0 || ampX > 1 || ampY < 0 || ampY > 8) {
            this.clearCurrentCell();
            return;
        }
        this.currentCell[4] = ampX;
        this.currentCell[5] = ampY;
        v = this.model.getValue(raftX, raftY, reb, ccdY, ampX, ampY);
        if (v != null) {
            this.currentValue = v;
        }
    }

    private void clearCurrentCell() {
        Arrays.fill((int[])this.currentCell, (int)-1);
        this.currentValue = null;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        this.setCurrentCell(event.getX(), event.getY());
        if (this.currentCell[0] == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<html>");
        sb.append("<h4>RAFT:").append(this.currentCell[0]).append(this.currentCell[1]);
        if (this.currentCell[2] != -1) {
            sb.append(", ");
            if (this.currentCell[3] == -1) {
                sb.append("Reb:").append(this.currentCell[2]);
            } else {
                sb.append("CCD:").append(this.currentCell[2]).append(this.currentCell[3]);
                if (this.currentCell[4] != -1) {
                    sb.append(", AMP:").append(this.currentCell[4]).append(this.currentCell[5]);
                }
            }
        }
        sb.append("</h4>");
        if (this.currentValue != null && this.currentValue.toolTip != null) {
            sb.append(this.currentValue.toolTip);
        }
        return sb.toString();
    }

    public Descriptor save() {
        return this.descriptor;
    }

    public static class Descriptor
    implements Serializable {
    }
}

