/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.Color;
import java.io.Serializable;
import java.util.Random;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.AbstractFocalPlaneMapModel;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.CCDType;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlane;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapModel;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapModelFactory;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapValue;

public class FakeModel2
extends AbstractFocalPlaneMapModel
implements FocalPlaneMapModelFactory {
    private String name;
    private static Random random = new Random();

    public FakeModel2(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public FocalPlaneMapModel getModel(Serializable descriptor) {
        return this;
    }

    @Override
    public FocalPlaneMapValue getValue(int raftX, int raftY) {
        CCDType type = FocalPlane.getType(raftX, raftY);
        if (type == CCDType.SCIENCE) {
            return FocalPlaneMapValue.EMPTY_SPLIT;
        }
        return FocalPlaneMapValue.EMPTY;
    }

    @Override
    public FocalPlaneMapValue getValue(int raftX, int raftY, int ccdX, int ccdY) {
        FocalPlaneMapValue v = new FocalPlaneMapValue();
        float p = random.nextFloat();
        if ((double)p > 0.96) {
            v.setColor(new Color(180, 0, 0));
        } else if ((double)p > 0.92) {
            v.setColor(Color.yellow);
        } else {
            int a = Math.min(Math.round(p * 3.0f * 255.0f), 255);
            v.setColor(new Color(0, 180, 0, a));
        }
        return v;
    }
}

