/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.array;

import java.lang.reflect.Array;
import nom.tam.util.array.MultyArrayCopyFactory;
import nom.tam.util.array.MultyArrayIterator;

public final class MultyArrayCopier {
    private final MultyArrayIterator from;
    private final MultyArrayIterator to;
    private Object currentToArray;
    private int currentToArrayOffset;
    private int currentToArrayLength;
    private final MultyArrayCopyFactory copyFacrory;

    public static void copyInto(Object fromArray, Object toArray) {
        new MultyArrayCopier(fromArray, toArray).copyInto();
    }

    private MultyArrayCopier(Object fromArray, Object toArray) {
        this.from = new MultyArrayIterator(fromArray);
        this.to = new MultyArrayIterator(toArray);
        this.copyFacrory = MultyArrayCopyFactory.select(this.from.deepComponentType(), this.to.deepComponentType());
    }

    private void copyInto() {
        Object current = this.from.next();
        while (current != null) {
            this.copyInto(current);
            current = this.from.next();
        }
    }

    private void copyInto(Object currentFromArray) {
        int currentFromArrayOffset = 0;
        int currentFromArrayLength = Array.getLength(currentFromArray);
        while (currentFromArrayOffset < currentFromArrayLength) {
            if (this.currentToArray == null || this.currentToArrayOffset >= this.currentToArrayLength) {
                this.currentToArray = this.to.next();
                this.currentToArrayOffset = 0;
                this.currentToArrayLength = Array.getLength(this.currentToArray);
            }
            int length = Math.min(this.currentToArrayLength - this.currentToArrayOffset, currentFromArrayLength - currentFromArrayOffset);
            this.copyFacrory.arraycopy(currentFromArray, currentFromArrayOffset, this.currentToArray, this.currentToArrayOffset, length);
            currentFromArrayOffset += length;
            this.currentToArrayOffset += length;
        }
    }
}

