/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.Serializable;
import java.util.Comparator;
import nom.tam.fits.header.Standard;

public class HeaderOrder
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(String c1, String c2) {
        if (c1.equals(c2)) {
            return 0;
        }
        if (c1.equals(Standard.SIMPLE.key()) || c1.equals(Standard.XTENSION.key())) {
            return -1;
        }
        if (c2.equals(Standard.SIMPLE.key()) || c2.equals(Standard.XTENSION.key())) {
            return 1;
        }
        if (c1.equals(Standard.BITPIX.key())) {
            return -1;
        }
        if (c2.equals(Standard.BITPIX.key())) {
            return 1;
        }
        if (c1.equals(Standard.NAXIS.key())) {
            return -1;
        }
        if (c2.equals(Standard.NAXIS.key())) {
            return 1;
        }
        if (this.naxisN(c1) > 0) {
            if (this.naxisN(c2) > 0) {
                if (this.naxisN(c1) < this.naxisN(c2)) {
                    return -1;
                }
                return 1;
            }
            return -1;
        }
        if (this.naxisN(c2) > 0) {
            return 1;
        }
        if (c1.equals(Standard.EXTEND.key())) {
            return -1;
        }
        if (c2.equals(Standard.EXTEND.key())) {
            return 1;
        }
        if (c1.equals(Standard.PCOUNT.key())) {
            return -1;
        }
        if (c2.equals(Standard.PCOUNT.key())) {
            return 1;
        }
        if (c1.equals(Standard.GCOUNT.key())) {
            return -1;
        }
        if (c2.equals(Standard.GCOUNT.key())) {
            return 1;
        }
        if (c1.equals(Standard.TFIELDS.key())) {
            return -1;
        }
        if (c2.equals(Standard.TFIELDS.key())) {
            return 1;
        }
        if (c1.equals(Standard.BLOCKED.key())) {
            return -1;
        }
        if (c2.equals(Standard.BLOCKED.key())) {
            return 1;
        }
        if (c1.equals(Standard.END.key())) {
            return 1;
        }
        if (c2.equals(Standard.END.key())) {
            return -1;
        }
        return 0;
    }

    public boolean equals(String a, String b) {
        return this.compare(a, b) == 0;
    }

    private int naxisN(String key) {
        int startOfNumber = Standard.NAXIS.key().length();
        if (key.length() > startOfNumber && key.substring(0, startOfNumber).equals(Standard.NAXIS.key())) {
            for (int i = startOfNumber; i < key.length(); ++i) {
                boolean number = true;
                char c = key.charAt(i);
                if ('0' > c || c > '9') {
                    number = false;
                    break;
                }
                if (!number) continue;
                return Integer.parseInt(key.substring(startOfNumber));
            }
        }
        return -1;
    }
}

