/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.gconsole.agent.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.subsystem.focalplane.data.FocalPlaneDataGroup;

@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter", name="FocalPlane monitor filter", path="Subsystems/FocalPlane/Monitor", description="FocalPlane subsystem monitor filter.")
public class FocalPlaneMonitorFilter
extends AbstractChannelsFilter {
    private final FocalPlaneDataGroup dataGroup;
    private String agentName;
    public static final List<String> FIELDS = new ArrayList<String>();

    public FocalPlaneMonitorFilter(String agents, FocalPlaneDataGroup dataGroup) {
        this.dataGroup = dataGroup;
        this.agentName = agents == null || agents.isEmpty() ? null : agents;
    }

    public String getName() {
        return "FP:" + this.dataGroup;
    }

    public List<String> getAgents() {
        return this.agentName == null ? null : Collections.singletonList(this.agentName);
    }

    public List<String> getFields(boolean compact) {
        return FIELDS;
    }

    public List<String> getOriginChannels() {
        return Collections.singletonList("agent." + DataProviderInfo.Attribute.DATA_GROUP.getName() + "=" + this.dataGroup.getName());
    }

    public List<String> getDisplayPath(String originPath) {
        int i = originPath.indexOf("/");
        if (this.agentName == null) {
            this.agentName = originPath.substring(0, i);
        }
        return Collections.singletonList(originPath.substring(i + 1));
    }

    public String getOriginPath(String displayPath) {
        return this.agentName + "/" + displayPath;
    }

    static {
        FIELDS.add(MonitorField.VALUE.getKey());
        FIELDS.add(MonitorField.UNITS.getKey());
        FIELDS.add(MonitorField.LOW_ALARM.getKey());
        FIELDS.add(MonitorField.LOW_WARN.getKey());
        FIELDS.add(MonitorField.ALERT_LOW.getKey());
        FIELDS.add(MonitorField.HIGH_WARN.getKey());
        FIELDS.add(MonitorField.HIGH_ALARM.getKey());
        FIELDS.add(MonitorField.ALERT_HIGH.getKey());
        FIELDS.add(MonitorField.NAME.getKey());
        FIELDS.add(MonitorField.DESCR.getKey());
    }
}

