package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.GridLayout;
import java.io.Serializable;
import java.util.*;
import javax.swing.JPanel;
import org.lsst.ccs.gconsole.base.Const;

/**
 * Graphic component that holds a grid of {@link FocalPlaneMapRegion}.
 *
 * @author onoprien
 */
public final class FocalPlaneMapPage extends JPanel {

// -- Fields : -----------------------------------------------------------------
    
    private final Descriptor descriptor;
    private final ArrayList<FocalPlaneMapRegion> regions;

// -- Life cycle : -------------------------------------------------------------

    public FocalPlaneMapPage(FocalPlaneMapModelFactory[] models) {
        this(models, 1,1);
    }

    public FocalPlaneMapPage(FocalPlaneMapModelFactory[] models, int nRows, int nColumns) {
        this(models, new Descriptor(nRows, nColumns));
    }

    public FocalPlaneMapPage(FocalPlaneMapModelFactory[] models, Descriptor desc) {
        this.descriptor = desc == null ? new Descriptor() : desc;
        setLayout(new GridLayout(descriptor.getRows(), descriptor.getColumns(), Const.HSPACE, Const.VSPACE));
        FocalPlaneMapRegion.Descriptor[] regionDescriptors = descriptor.getRegions();
        int n = descriptor.getRows() * descriptor.getColumns();
        regions = new ArrayList<>(n);
        for (int i=0; i<n; i++) {
            FocalPlaneMapRegion region = new FocalPlaneMapRegion(models, regionDescriptors == null ? null : regionDescriptors[i]);
            add(region);
            regions.add(region);
        }
    }
    
    public void opened() {
        regions.forEach(region -> region.opened());
    }
    
    public void closed() {
        regions.forEach(region -> region.closed());
    }
    
// -- Saving : -----------------------------------------------------------------
    
    public Descriptor save() {
        int n = regions.size();
        FocalPlaneMapRegion.Descriptor[] regionDescriptors = new FocalPlaneMapRegion.Descriptor[n];
        for (int i = 0; i < n; i++) {
            regionDescriptors[i] = regions.get(i).save();
        }
        descriptor.setRegions(regionDescriptors);
        return descriptor;
    }
    
    static public class Descriptor implements Serializable {
        
        public Descriptor() {
            this(1,1);
        }
        
        public Descriptor(int nRows, int nColumns) {
            rows = nRows;
            columns = nColumns;
        }

        private String name;
        private int rows;
        private int columns;
        private FocalPlaneMapRegion.Descriptor[] regions;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }
        
        public int getRows() {
            return rows;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public int getColumns() {
            return columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }

        public FocalPlaneMapRegion.Descriptor[] getRegions() {
            return regions;
        }

        public void setRegions(FocalPlaneMapRegion.Descriptor[] regions) {
            this.regions = regions;
        }
        
    }
    
    
    
    
}
