package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.Color;
import java.io.Serializable;
import java.util.Random;

/**
 * 
 *
 * @author onoprien
 */
public class FakeModel2 extends AbstractFocalPlaneMapModel implements FocalPlaneMapModelFactory {

// -- Fields : -----------------------------------------------------------------
    
    private String name;
    static private Random random = new Random();

// -- Life cycle : -------------------------------------------------------------
    
    public FakeModel2(String name) {
        this.name = name;
    }
    
// -- Implementing FocalPlaneMapModelFactory : ---------------------------------

    @Override
    public String toString() {
        return name;
    }

    @Override
    public FocalPlaneMapModel getModel(Serializable descriptor) {
        return this;
    }
    
// -- Model : ------------------------------------------------------------------

    @Override
    public FocalPlaneMapValue getValue(int raftX, int raftY) {
        CCDType type = FocalPlane.getType(raftX, raftY);
        if (type == CCDType.SCIENCE) {
            return FocalPlaneMapValue.EMPTY_SPLIT;
        } else {
            return FocalPlaneMapValue.EMPTY;
        }
    }

    @Override
    public FocalPlaneMapValue getValue(int raftX, int raftY, int ccdX, int ccdY) {
        FocalPlaneMapValue v = new FocalPlaneMapValue();
        float p = random.nextFloat();
        if (p > .96) {
            v.setColor(new Color(180, 0, 0));
        } else if (p > .92) {
            v.setColor(Color.yellow);
        } else {
            int a = Math.min( Math.round(p*3*255), 255 );
            v.setColor(new Color(0, 180, 0, a));
        }
        return v;
    }

}
