package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.Color;
import java.io.Serializable;

/**
 * 
 *
 * @author onoprien
 */
public class FakeModel1 extends AbstractFocalPlaneMapModel implements FocalPlaneMapModelFactory {

// -- Fields : -----------------------------------------------------------------
    
    private String name;

// -- Life cycle : -------------------------------------------------------------
    
    public FakeModel1(String name) {
        this.name = name;
    }
    
// -- Implementing FocalPlaneMapModelFactory : ---------------------------------

    @Override
    public String toString() {
        return name == null ? "Alarms" : name;
    }

    @Override
    public FocalPlaneMapModel getModel(Serializable descriptor) {
        return this;
    }
    
// -- Model : ------------------------------------------------------------------

//    @Override
//    public FocalPlaneMapValue getValue(CCDType type) {
//        FocalPlaneMapValue v = new FocalPlaneMapValue();
//        switch (type) {
////            case SCIENCE:
////                v.setColor(Color.GREEN);
//            case CORNER:
//               return FocalPlaneMapValue.EMPTY_SPLIT;
//            default:
//                v.setColor(Color.GREEN);
//        }
//        return v;
//    }

    @Override
    public FocalPlaneMapValue getValue(int raftX, int raftY) {
        FocalPlaneMapValue v = new FocalPlaneMapValue();
        if (raftX == 2 && raftY == 3) {
            v.setColor(Color.YELLOW);
        } else {
            CCDType type = FocalPlane.getType(raftX, raftY);
            if (type == CCDType.SCIENCE) {
                v.setColor(new Color(0, 180, 0));
            } else {
                v = FocalPlaneMapValue.EMPTY_SPLIT;
            }
        }
        return v;
    }

    @Override
    public FocalPlaneMapValue getValue(int raftX, int raftY, int ccdX, int ccdY) {
        FocalPlaneMapValue v = new FocalPlaneMapValue();
        if (raftX == 0 && ccdY == 2) {
            v.setColor(new Color(180, 0, 0));
        } else if (raftX == 4 && raftY == 4 && ccdY == 1) {
            v.setColor(Color.YELLOW);
        } else {
            v.setColor(new Color(0, 180, 0));
        }
        return v;
    }

}
