package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.io.Serializable;
import org.lsst.ccs.subsystem.focalplane.data.FocalPlaneDataGroup;
import org.lsst.ccs.subsystem.focalplane.ui.FocalPlaneMonitorFilter;

/**
 * 
 *
 * @author onoprien
 */
public class DataGroupFactory implements FocalPlaneMapModelFactory {

// -- Fields : -----------------------------------------------------------------
    
    private final String agent;
    private final FocalPlaneDataGroup group;
    private MonitorViewModel view;

// -- Life cycle : -------------------------------------------------------------
    
    public DataGroupFactory(String agent, FocalPlaneDataGroup group) {
        this.agent = agent;
        this.group = group;
    }

// -- Creating model : ---------------------------------------------------------
    
    @Override
    public String toString() {
        return group.getName();
    }

    @Override
    public FocalPlaneMapModel getModel(Serializable descriptor) {
        if (view == null) {
            view = new MonitorViewModel();
            view.setFilter(new FocalPlaneMonitorFilter(agent, group));
        }
        return view.getFocalPlaneMapModel();
    }
    
}
