/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.util.session.Savable;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.Segment;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.Template;

public class TemplateFilter
extends AbstractChannelsFilter
implements Savable {
    private final Descriptor descriptor;
    private final ArrayList<Template> templates;
    private final HashSet<String> accept = new HashSet();
    private final HashSet<String> reject = new HashSet();

    public TemplateFilter(Descriptor descriptor) {
        this.descriptor = descriptor;
        String[] tt = descriptor.getTemplates();
        this.templates = new ArrayList(tt.length);
        for (String s : tt) {
            this.templates.add(Template.valueOf(s));
        }
    }

    public TemplateFilter(String title, List<Template> templates, Segment granularity) {
        this.descriptor = new Descriptor();
        this.descriptor.setTitle(title);
        String[] tt = new String[templates.size()];
        int i = 0;
        for (Template template : templates) {
            tt[i++] = template.toString();
        }
        this.descriptor.setTemplates(tt);
        this.templates = new ArrayList<Template>(templates);
    }

    public String getName() {
        return this.descriptor.getTitle();
    }

    public List<String> getAgents() {
        LinkedHashSet<String> aa = new LinkedHashSet<String>(this.descriptor.getTemplates().length * 2);
        for (Template t : this.templates) {
            aa.add(t.code.substring(0, t.code.indexOf("/")));
        }
        return new ArrayList<String>(aa);
    }

    public String getOriginPath(String displayPath) {
        return displayPath;
    }

    public List<String> getDisplayPath(AgentChannel channel) {
        if (channel == null) {
            return Collections.emptyList();
        }
        String path = channel.getPath();
        if (this.accept.contains(path)) {
            return Collections.singletonList(path);
        }
        if (this.reject.contains(path)) {
            return Collections.emptyList();
        }
        Template t = Template.valueOf(channel);
        if (this.templates.contains(t)) {
            this.accept.add(path);
            return Collections.singletonList(path);
        }
        this.reject.add(path);
        return Collections.emptyList();
    }

    public Descriptor save() {
        return this.descriptor;
    }

    public static class Descriptor
    implements Serializable {
        private String granularity;
        private String[] templates;
        private String title;

        public String getGranularity() {
            return this.granularity;
        }

        public void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        public String[] getTemplates() {
            return this.templates;
        }

        public void setTemplates(String[] templates) {
            this.templates = templates;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }
}

