/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.util.session.Savable;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.DataGroupFactory;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMap;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapModel;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapModelFactory;

public final class FocalPlaneMapRegion
extends JPanel
implements Savable {
    private Descriptor descriptor;
    private final FocalPlaneMapModelFactory[] modelFactories;
    private final FocalPlaneMap map;
    private final JLabel titleLabel;
    private final JComboBox<FocalPlaneMapModelFactory> comboBox;
    private boolean restoring = false;

    public FocalPlaneMapRegion(FocalPlaneMapModelFactory[] models, Descriptor desc) {
        super(new BorderLayout());
        this.modelFactories = models;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLineBorder(Color.BLACK, 1, true)));
        this.map = new FocalPlaneMap();
        this.add((Component)this.map, "Center");
        Box header = Box.createHorizontalBox();
        this.add((Component)header, "North");
        this.comboBox = new JComboBox<FocalPlaneMapModelFactory>(this.modelFactories);
        header.add(this.comboBox);
        this.comboBox.addActionListener(e -> {
            FocalPlaneMapModelFactory f = (FocalPlaneMapModelFactory)this.comboBox.getSelectedItem();
            if (!this.restoring) {
                this.setCurrentFactory(f);
            }
        });
        header.add(Box.createRigidArea(Const.HDIM));
        this.titleLabel = new JLabel();
        header.add(this.titleLabel);
        header.add(Box.createHorizontalGlue());
        this.restore(desc);
    }

    public void opened() {
    }

    public void closed() {
        this.map.setModel(null);
    }

    public void setTitle(String title) {
        if (title == null && ((title = this.map.getName()) == null || (FocalPlaneMapModelFactory)this.comboBox.getSelectedItem() instanceof DataGroupFactory)) {
            title = "";
        }
        this.titleLabel.setText(title.isEmpty() ? "" : "<html><b>" + title);
    }

    private void setCurrentFactory(FocalPlaneMapModelFactory factory) {
        try {
            String oldFactory = this.descriptor.getModelFactory();
            String newFactory = factory.toString();
            Serializable desc = Objects.equals(oldFactory, newFactory) ? this.descriptor.getModel() : null;
            FocalPlaneMapModel model = factory.createModel(desc);
            this.map.setModel(model);
            this.setTitle(null);
            this.descriptor.setModelFactory(newFactory);
            this.descriptor.setModel(model.save());
        }
        catch (NullPointerException x) {
            this.descriptor.setModel(null);
            this.descriptor.setModelFactory(null);
            this.setTitle("");
        }
    }

    public Descriptor save() {
        this.descriptor.setMap(this.map.save());
        return this.descriptor;
    }

    public void restore(Serializable desc) {
        try {
            this.descriptor = (Descriptor)desc;
            String currentModelName = this.descriptor.getModelFactory();
            FocalPlaneMapModelFactory currentFactory = null;
            for (FocalPlaneMapModelFactory fac : this.modelFactories) {
                if (!currentModelName.equals(fac.toString())) continue;
                currentFactory = fac;
                break;
            }
            this.restoring = true;
            this.comboBox.setSelectedItem(currentFactory);
            this.restoring = false;
            FocalPlaneMapModel model = currentFactory.getModel(this.descriptor.getModel());
            this.map.setModel(model);
            this.setTitle(null);
        }
        catch (ClassCastException | NullPointerException x) {
            this.descriptor = new Descriptor();
        }
    }

    public static class Descriptor
    implements Serializable {
        private FocalPlaneMap.Descriptor map;
        private String modelFactory;
        private Serializable model;

        public FocalPlaneMap.Descriptor getMap() {
            return this.map;
        }

        public void setMap(FocalPlaneMap.Descriptor map) {
            this.map = map;
        }

        public String getModelFactory() {
            return this.modelFactory;
        }

        public void setModelFactory(String modelFactory) {
            this.modelFactory = modelFactory;
        }

        public Serializable getModel() {
            return this.model;
        }

        public void setModel(Serializable model) {
            this.model = model;
        }
    }
}

