/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.GridLayout;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapModelFactory;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapRegion;

public final class FocalPlaneMapPage
extends JPanel {
    private final Descriptor descriptor;
    private final ArrayList<FocalPlaneMapRegion> regions;

    public FocalPlaneMapPage(FocalPlaneMapModelFactory[] models) {
        this(models, 1, 1);
    }

    public FocalPlaneMapPage(FocalPlaneMapModelFactory[] models, int nRows, int nColumns) {
        this(models, new Descriptor(nRows, nColumns));
    }

    public FocalPlaneMapPage(FocalPlaneMapModelFactory[] models, Descriptor desc) {
        this.descriptor = desc == null ? new Descriptor() : desc;
        this.setLayout(new GridLayout(this.descriptor.getRows(), this.descriptor.getColumns(), 10, 5));
        FocalPlaneMapRegion.Descriptor[] regionDescriptors = this.descriptor.getRegions();
        int n = this.descriptor.getRows() * this.descriptor.getColumns();
        this.regions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            FocalPlaneMapRegion region = new FocalPlaneMapRegion(models, regionDescriptors == null ? null : regionDescriptors[i]);
            this.add(region);
            this.regions.add(region);
        }
    }

    public void opened() {
        this.regions.forEach(region -> region.opened());
    }

    public void closed() {
        this.regions.forEach(region -> region.closed());
    }

    public Descriptor save() {
        int n = this.regions.size();
        FocalPlaneMapRegion.Descriptor[] regionDescriptors = new FocalPlaneMapRegion.Descriptor[n];
        for (int i = 0; i < n; ++i) {
            regionDescriptors[i] = this.regions.get(i).save();
        }
        this.descriptor.setRegions(regionDescriptors);
        return this.descriptor;
    }

    public static class Descriptor
    implements Serializable {
        private String name;
        private int rows;
        private int columns;
        private FocalPlaneMapRegion.Descriptor[] regions;

        public Descriptor() {
            this(1, 1);
        }

        public Descriptor(int nRows, int nColumns) {
            this.rows = nRows;
            this.columns = nColumns;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getRows() {
            return this.rows;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public int getColumns() {
            return this.columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }

        public FocalPlaneMapRegion.Descriptor[] getRegions() {
            return this.regions;
        }

        public void setRegions(FocalPlaneMapRegion.Descriptor[] regions) {
            this.regions = regions;
        }
    }
}

