/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentHandle;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.ComponentDictionary;
import org.lsst.ccs.utilities.structs.TreeBranch;

public final class DictionaryTreePanel
extends JTree {
    private final AgentPanel.Descriptor descriptor;
    private TreeBranch<ComponentDictionary> dictionaryTree;
    private AgentHandle agent;

    DictionaryTreePanel(AgentPanel agentPanel) {
        this.descriptor = agentPanel.descriptor;
        this.setModel(new DefaultTreeModel((TreeNode)this.dictionaryTree));
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new Renderer());
    }

    void updateData(AgentHandle dict) {
        this.agent = dict;
        if (this.agent == null) {
            this.setModel(new DefaultTreeModel(null));
        } else {
            new BuildDictionaryWorker(dict).execute();
        }
    }

    public void updateRenderer() {
        if (this.descriptor.isHideUnavailableCommands()) {
            this.updateData(this.agent);
        } else {
            this.revalidate();
            this.repaint();
        }
    }

    public void setHideUnavailable(boolean hide) {
        if (hide != this.descriptor.isHideUnavailableCommands()) {
            this.descriptor.setHideUnavailableCommands(hide);
            this.updateData(this.agent);
        }
    }

    private void sort(TreeBranch<ComponentDictionary> node) {
        if (!node.isLeaf()) {
            ArrayList children = (ArrayList)node.getChildren();
            children.sort(new Sorter());
            children.forEach(child -> this.sort((TreeBranch<ComponentDictionary>)child));
        }
    }

    private static class Sorter
    implements Comparator<TreeBranch<ComponentDictionary>> {
        private Sorter() {
        }

        @Override
        public int compare(TreeBranch<ComponentDictionary> o1, TreeBranch<ComponentDictionary> o2) {
            boolean leaf2;
            boolean leaf1 = o1.isLeaf();
            if (leaf1 == (leaf2 = o2.isLeaf())) {
                int out;
                String[] path1 = ((ComponentDictionary)o1.getContent()).path.split("/");
                String[] path2 = ((ComponentDictionary)o2.getContent()).path.split("/");
                int i = 0;
                while (true) {
                    if (i == path1.length) {
                        return i == path2.length ? 0 : -1;
                    }
                    if (i == path2.length) {
                        return 1;
                    }
                    out = path1[i].compareTo(path2[i]);
                    if (out != 0) break;
                    ++i;
                }
                return out;
            }
            return leaf1 ? 1 : -1;
        }
    }

    private static class Renderer
    extends DefaultTreeCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.setForeground(Renderer.greyOut((TreeBranch<ComponentDictionary>)((TreeBranch)value)) ? Color.GRAY : Color.BLACK);
            return this;
        }

        static boolean greyOut(TreeBranch<ComponentDictionary> tree) {
            try {
                for (TreeBranch child : tree.getChildren()) {
                    if (Renderer.greyOut((TreeBranch<ComponentDictionary>)child)) continue;
                    return false;
                }
                Dictionary d = ((ComponentDictionary)tree.getContent()).dictionary;
                for (DictionaryCommand dc : d) {
                    if (dc.getLevel() > d.getLevel() || !d.getVisibilityForType(dc.getType())) continue;
                    return false;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return true;
        }
    }

    private class BuildDictionaryWorker
    extends SwingWorker<TreeBranch<ComponentDictionary>, String> {
        private final AgentHandle agentHandle;
        Map<String, Dictionary> dictionaries;
        Map<String, CommandSet> commandSets;

        BuildDictionaryWorker(AgentHandle dict) {
            this.agentHandle = dict;
            this.dictionaries = new HashMap<String, Dictionary>(this.agentHandle.dictionaries);
            this.commandSets = this.agentHandle.commandSets;
        }

        @Override
        protected TreeBranch<ComponentDictionary> doInBackground() throws Exception {
            TreeBranch dictionaryTree = null;
            String rootName = this.agentHandle.getName();
            Dictionary rootDictionary = this.dictionaries.remove(rootName);
            dictionaryTree = new TreeBranch((Serializable)new ComponentDictionary(rootName, rootName, rootDictionary, this.commandSets.get(rootName)));
            for (Map.Entry<String, Dictionary> entry : this.dictionaries.entrySet()) {
                TreeBranch treeWalker = dictionaryTree;
                String[] pathTab = entry.getKey().split("/");
                for (int i = 1; i < pathTab.length; ++i) {
                    boolean found = false;
                    if (treeWalker.getChildren() != null) {
                        Iterator it = treeWalker.getChildIterator();
                        while (it.hasNext() && !found) {
                            TreeBranch currIt = (TreeBranch)it.next();
                            if (!((ComponentDictionary)currIt.getContent()).name.equals(pathTab[i])) continue;
                            treeWalker = currIt;
                            found = true;
                            if (i != pathTab.length - 1) continue;
                            treeWalker.setContent((Serializable)new ComponentDictionary(entry.getKey(), pathTab[i], entry.getValue(), this.commandSets.get(entry.getKey())));
                        }
                    }
                    if (found) continue;
                    treeWalker = new TreeBranch(treeWalker, (Serializable)new ComponentDictionary(entry.getKey(), pathTab[i], entry.getValue(), this.commandSets.get(entry.getKey())));
                }
            }
            this.removeLeafsWithEmptyDicts((TreeBranch<ComponentDictionary>)dictionaryTree);
            if (DictionaryTreePanel.this.descriptor.isHideUnavailableCommands()) {
                this.removeUnavailable((TreeBranch<ComponentDictionary>)dictionaryTree);
            }
            DictionaryTreePanel.this.sort((TreeBranch<ComponentDictionary>)dictionaryTree);
            return dictionaryTree;
        }

        private void removeLeafsWithEmptyDicts(TreeBranch<ComponentDictionary> node) {
            Iterator it = node.getChildIterator();
            while (it.hasNext()) {
                TreeBranch currIt = (TreeBranch)it.next();
                this.removeLeafsWithEmptyDicts((TreeBranch<ComponentDictionary>)currIt);
                if (currIt.getChildCount() != 0 || ((ComponentDictionary)currIt.getContent()).dictionary.iterator().hasNext()) continue;
                it.remove();
            }
        }

        private void removeUnavailable(TreeBranch<ComponentDictionary> node) {
            Iterator it = node.getChildIterator();
            while (it.hasNext()) {
                TreeBranch currIt = (TreeBranch)it.next();
                if (!Renderer.greyOut((TreeBranch<ComponentDictionary>)currIt)) continue;
                it.remove();
            }
        }

        @Override
        public void done() {
            try {
                DictionaryTreePanel.this.dictionaryTree = (TreeBranch)this.get();
                if (DictionaryTreePanel.this.dictionaryTree != null) {
                    DictionaryTreePanel.this.setModel(new DefaultTreeModel((TreeNode)DictionaryTreePanel.this.dictionaryTree));
                    DictionaryTreePanel.this.getSelectionModel().setSelectionPath(new TreePath(DictionaryTreePanel.this.getModel().getRoot()));
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                ex.printStackTrace();
            }
        }
    }
}

