package org.lsst.ccs.subsystem.focalplane.states;

/**
 * Set of states for the focal plane. These states are documented in
 * LSE-71 and sent to the OCS.
 * @author tonyj
 */
public enum FocalPlaneState {
    /** Idle clearing state */
    IDLE_CLEAR, 
    /** In the process of clearing the CCDs */
    CLEARING, 
    /** Integrating */
    INTEGRATING, 
    /** Reading out */
    READING_OUT, 
    /** IDLE, but ready to take an image without a clear */
    QUIESCENT,
    /** Performing a row shift operation */
    ROW_SHIFT, 
    /** Readout finished, but waiting for 2-day store */
    IMAGE_WAIT
}
