package org.lsst.ccs.subsystem.focalplane.data;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * A LinkedHashMap which overrides toString to format one item per line.Useful
 * for returning from commands since it allows access to the map from a script,
 * but also formats it readably.
 *
 * @author tonyj
 * @param <K> The key type
 * @param <V> The value type
 */
public class FormattedHashMap<K, V> extends LinkedHashMap<K, V> {

    private final String format;

    /**
     * Create a FormattedHashMap with default formatting.
     */
    public FormattedHashMap() {
        this(null);
    }

    /**
     * Create a FormattedHashMap with optional format string
     *
     * @param format The format string to use for formatting the value, or <code>null</code>
     * to use the default toString() method.
     */
    public FormattedHashMap(String format) {
        this.format = format;
    }

    @Override
    public String toString() {
        List<String> result = this.entrySet().stream().map((e) -> e.getKey() + ": " + format(e.getValue())).collect(Collectors.toList());
        return String.join("\n", result);
    }

    private String format(V value) {
        return format == null ? value.toString() : String.format(format, value);
    }

}
