package org.lsst.ccs.subsystem.focalplane.alerts;

/**
 * Focal Plane Alerts Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum FocalPlaneAlertType {

    /**
     * Alert raised when the ASPICs temperature is too hot.
     */
    ASPICS_TEMPERATURE_TOO_HIGH("Aspics_High_Temp","Alert for Aspics temperture too high"),
    /**
     * Alert raised when the ASPICs temperature is too hot.
     */
    ASPICS_TEMPERATURE_TOO_LOW("Aspics_Low_Temp","Alert for Aspics temperture too low"),
    /**
     * Alert raised when the Reb Board temperature is too hot.
     */
    REB_BOARD_TEMPERATURE_TOO_HIGH("Reb_Board_High_Temp","Alert for Reb Board temperture too high"),
    /**
     * Alert raised when the Reb Board temperature is too low.
     */
    REB_BOARD_TEMPERATURE_TOO_LOW("Reb_Board_Low_Temp","Alert for Reb Board temperture too low");
    
    
    private final String id, description;
    
    FocalPlaneAlertType(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getAlertId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
}
