package org.lsst.ccs.subsystem.focalplane.data;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.DoNotTrend;

/**
 *
 * @author tonyj
 */
//To be uncommented with toolkit 5.3.15
//@DoNotTrend
@DataAttributes(units = "unitless")
public class SequencerInfo implements Serializable {

    private static final long serialVersionUID = 7021332963393L;
    
    @DataAttributes(description = "The sequencer file's name")
    private final String sequencerFile;

    @DataAttributes(description = "The sequencer file's checksum.")
    private final String sequencerChecksum;
    

    public SequencerInfo(String sequencerFile, String sequencerChecksum) {
        this.sequencerChecksum = sequencerChecksum;
        this.sequencerFile = sequencerFile;
    }

    public String getSequencerChecksum() {
        return sequencerChecksum;
    }

    public String getSequencerFile() {
        return sequencerFile;
    }

}
