package org.lsst.ccs.subsystem.focalplane.data;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

/**
 *
 * @author tonyj
 */
//To be uncommented with toolkit 5.3.15
//@DoNotTrend
@DataAttributes(units = "s")
public class ImageMetaDataEvent implements Serializable {

    private static final long serialVersionUID = -68951332963342L;
    
    public static String EVENT_KEY = "ImageMetaData";

    private final ImageName imageName;
    private final double darkTime;
    private final String daqTag;
    private final CCSTimeStamp lastClearTime;
    private final CCSTimeStamp integrationStartTime;
    private final CCSTimeStamp integrationEndTime;

    public ImageMetaDataEvent(ImageName imageName, double darkTime, String daqTag, CCSTimeStamp lastClearTime, CCSTimeStamp integrationStartTime, CCSTimeStamp integrationEndTime) {
        this.imageName = imageName;
        this.darkTime = darkTime;
        this.daqTag = daqTag;
        this.lastClearTime = lastClearTime;
        this.integrationStartTime = integrationStartTime;
        this.integrationEndTime = integrationEndTime;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public ImageName getImageName() {
        return imageName;
    }

    public CCSTimeStamp getLastClearTime() {
        return lastClearTime;
    }

    public double getDarkTime() {
        return darkTime;
    }

    public String getDaqTag() {
        return daqTag;
    }

    public CCSTimeStamp getIntegrationStartTime() {
        return integrationStartTime;
    }

    public CCSTimeStamp getIntegrationEndTime() {
        return integrationEndTime;
    }

}
