/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.errors.HardwareErrorDetectedException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftCarouselModule;

public class SftMainModule
extends Module {
    private Filter dummyFilter;
    private SftCarouselModule carousel;
    private SftAutoChangerModule autochanger;
    private int limitMax = 15;

    public void initModule() {
        this.carousel = (SftCarouselModule)this.getModule("carousel");
        this.autochanger = (SftAutoChangerModule)this.getModule("autochanger");
    }

    private void locateFilters() {
        this.carousel.getSockets()[0].putFilterOnSocket(this.dummyFilter);
        this.carousel.engageClampsContact();
    }

    public String printFilters() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getName()) + " printFilters \n ");
        sb.append(this.dummyFilter.getName());
        sb.append(" position: ").append(this.carousel.getFilterPosition(this.dummyFilter));
        sb.append(" socket number: ").append(this.carousel.getSocketNumber(this.dummyFilter));
        sb.append(" standby position: ").append(this.carousel.getStandbyPositionForFilter(this.dummyFilter));
        Module.log.info((Object)sb.toString());
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\n").append(this.carousel.toString());
        sb.append("\n").append(this.autochanger.toString());
        return sb.toString();
    }

    public String displayData() {
        StringBuilder sb = new StringBuilder("Data published by ");
        sb.append(this.getContext().getSubsystem().getName()).append("\n  ");
        sb.append(CarouselModule.publishedByCarouselOutputName);
        sb.append(this.carousel.getStatusData().toString());
        sb.append("\n  ");
        sb.append(AutoChangerModule.publishedByAutoChangerOutputName);
        sb.append(this.autochanger.getStatusData().toString());
        return sb.toString();
    }

    public String goToInitialStateForSequence1() {
        return null;
    }

    public String executeSequence1() throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException {
        Module.log.info((Object)"Autochanger trucks moving empty to standby position.");
        this.autochanger.grabbeFilterAtStandby(this.getDummyFilter());
        Module.log.info((Object)"Carousel is ungrabbing filter at standby position.");
        this.carousel.ungrabbeFilterAtStandby(this.getDummyFilter());
        Module.log.info((Object)"Autochanger trucks moving loaded with the filter to standback position.");
        this.autochanger.moveFilterToStandback(this.dummyFilter);
        this.carousel.getSocketAtStandby().getClampXminus().updateStateWithSensors();
        this.carousel.getSocketAtStandby().getClampXplus().updateStateWithSensors();
        this.carousel.releaseClamps();
        Module.log.info((Object)"Autochanger trucks moving back the filter to standby position.");
        this.autochanger.moveFilterToStandby(this.dummyFilter);
        Module.log.info((Object)"Carousel is grabbing filter at standby position.");
        this.carousel.grabbeFilterAtStandby(this.getDummyFilter());
        Module.log.info((Object)"Autochanger moving back empty to online position.");
        this.autochanger.unGrabbeFilterAtStandby();
        return String.valueOf(this.getName()) + " Execution of Sequence1 completed";
    }

    public String executeSequence1(int nb) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException {
        if (nb < 1 || nb > 20000) {
            throw new IllegalArgumentException("nb has to be comprise between 1 and 20000");
        }
        int i = 1;
        while (i < nb) {
            Module.log.info((Object)("Executing Sequence1 " + i + " times"));
            this.executeSequence1();
            ++i;
        }
        return String.valueOf(this.getName()) + "Many Executions of Sequence1 completed";
    }

    boolean autochangerLatchesAreLocked() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Filter getDummyFilter() {
        return this.dummyFilter;
    }

    public void setDummyFilter(Filter dummyFilter) {
        this.dummyFilter = dummyFilter;
    }

    public Filter getFilterAtStandby() {
        return this.carousel.getFilterAtStandby();
    }
}

