/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.common.FilterClampState;
import org.lsst.ccs.subsystems.fcs.simulation.SimuSensor12bits;

public abstract class SimuFilterClampModule
extends FilterClampModule {
    private double trucksPositionLimit;
    private boolean atStandby;
    public CarouselModule carousel;
    private BasicAutoChangerModule autochanger;

    @Override
    public abstract boolean isLocked();

    @Override
    public void initModule() {
        this.carousel = (CarouselModule)this.getModule("carousel");
        this.autochanger = (BasicAutoChangerModule)this.getModule("autochanger");
        this.initPublishedData();
        this.state = FilterClampState.CLAMPEDONFILTER;
        ((SimuSensor12bits)this.getFilterPresenceSensor()).setNewRange(this.getValueA(), this.getValueB());
        this.trucksPositionLimit = 5.0;
        this.setAtStandby(false);
    }

    @Override
    public synchronized void tick() {
        if (!this.autochanger.isEmpty() && this.autochanger.getTrucksPosition() > this.trucksPositionLimit) {
            ((SimuSensor12bits)this.getFilterPresenceSensor()).setNewRange(this.getValueC(), ((SimuSensor12bits)this.getFilterPresenceSensor()).getMaxValue());
        } else {
            ((SimuSensor12bits)this.getFilterPresenceSensor()).setNewRange(this.getValueA(), this.getValueB());
        }
        this.updateStateWithSensors();
        Module.log.debug((Object)(String.valueOf(this.getName()) + " : filterPresence =" + this.filterPresence.toString()));
        this.publishedByClamp.update(this);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.publishedByClampOutputName, (Object)this.publishedByClamp));
    }

    public boolean isAtStandby() {
        return this.atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }
}

