/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;

public abstract class ClampActuatorModule
extends Module
implements Actuator {
    static int MAXI_VELOCITY = 0;
    static int MAXI_ACCELERATION = 0;
    static int MAXI_CURRENTLIMIT = 0;
    static int MAXI_SPEED = 0;
    static int MAXI_CONSTANTWINDING = 0;
    CanOpenProxy carouselProxy = (CanOpenProxy)this.getModule("carouselProxy");
    int nodeID;
    int inputID;
    ActuatorMode mode;
    int maxProfileVelocity;
    int maxAcceleration;
    int continuousCurrentLimit;
    int maxSpeedInCurrentMode;
    int thermalTimeConstantWinding;
    private int currentValue;
    private int velocityValue;
    private boolean isOn;

    public ClampActuatorModule(int nodeID, int inputID) {
        this.nodeID = nodeID;
        this.inputID = inputID;
        this.mode = ActuatorMode.CURRENT;
        this.maxProfileVelocity = MAXI_VELOCITY;
        this.maxAcceleration = MAXI_ACCELERATION;
        this.continuousCurrentLimit = MAXI_CURRENTLIMIT;
        this.maxSpeedInCurrentMode = MAXI_SPEED;
        this.thermalTimeConstantWinding = MAXI_CONSTANTWINDING;
        this.currentValue = 0;
        this.velocityValue = 0;
        this.isOn = false;
    }

    public int getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(int currentValue) {
        this.currentValue = currentValue;
    }

    public int getVelocityValue() {
        return this.velocityValue;
    }

    public void setVelocityValue(int velocityValue) {
        this.velocityValue = velocityValue;
    }

    public void initModule() {
        this.carouselProxy = (CanOpenProxy)this.getModule("carouselProxy");
    }

    public void enable() {
        this.writeDAC(6040, 0, 6);
        this.writeDAC(6040, 0, 15);
    }

    public void setMaxiVelocity(int velocity) {
        if (velocity > MAXI_VELOCITY) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + ": can't set parameters greater than maxi value");
        }
        this.maxProfileVelocity = velocity;
        this.writeDAC(24703, 0, velocity);
    }

    public void setMaxiAcceleration(int acceleration) {
        if (acceleration > MAXI_ACCELERATION) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + ": can't set parameters greater than maxi value");
        }
        this.maxAcceleration = acceleration;
        this.writeDAC(24773, 0, acceleration);
    }

    public void setVelocity() throws BadCommandException {
        if (!this.mode.equals((Object)ActuatorMode.VELOCITY)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in VELOCITY mode");
        }
        this.writeDAC(8299, 0, this.velocityValue);
    }

    public void stopVelocity() throws BadCommandException {
        if (!this.mode.equals((Object)ActuatorMode.VELOCITY)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in VELOCITY mode");
        }
        this.writeDAC(8299, 0, 0);
    }

    public void setCurrent() throws BadCommandException {
        if (!this.mode.equals((Object)ActuatorMode.CURRENT)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in CURRENT mode");
        }
        this.writeDAC(8240, 0, this.currentValue);
    }

    public void stopCurrent() throws BadCommandException {
        if (!this.mode.equals((Object)ActuatorMode.CURRENT)) {
            throw new BadCommandException(String.valueOf(this.getName()) + "is not in CURRENT mode");
        }
        this.writeDAC(8240, 0, 0);
    }

    public void quickStop() {
        if (this.mode.equals((Object)ActuatorMode.VELOCITY)) {
            this.writeDAC(24640, 0, 11);
        } else if (this.mode.equals((Object)ActuatorMode.CURRENT)) {
            this.writeDAC(24640, 0, 2);
        }
    }

    @Override
    public String on() {
        if (this.mode.equals((Object)ActuatorMode.VELOCITY)) {
            try {
                this.setVelocity();
            }
            catch (BadCommandException ex) {
                Logger.getLogger(ClampActuatorModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (this.mode.equals((Object)ActuatorMode.CURRENT)) {
            try {
                this.setCurrent();
            }
            catch (BadCommandException ex) {
                Logger.getLogger(ClampActuatorModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.isOn = true;
        return String.valueOf(this.getName()) + "Actuator ON";
    }

    @Override
    public String off() {
        if (this.mode.equals((Object)ActuatorMode.VELOCITY)) {
            try {
                this.stopVelocity();
            }
            catch (BadCommandException ex) {
                Logger.getLogger(ClampActuatorModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (this.mode.equals((Object)ActuatorMode.CURRENT)) {
            try {
                this.stopCurrent();
            }
            catch (BadCommandException ex) {
                Logger.getLogger(ClampActuatorModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.isOn = false;
        return String.valueOf(this.getName()) + "Actuator OFF";
    }

    @Override
    public boolean isOn() {
        return this.isOn;
    }

    @Override
    public boolean isOff() {
        return !this.isOn;
    }

    public int writeDAC(int index, int subindex, int newValue) {
        return this.carouselProxy.writeDAC(this.nodeID, this.inputID, index, subindex, newValue);
    }

    public static enum ActuatorMode {
        VELOCITY,
        CURRENT;

    }
}

