/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.drivers.ApcTcpProxy;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.drivers.HardwareNotBootedError;
import org.lsst.ccs.subsystems.fcs.errors.BootingHardwareError;
import org.lsst.ccs.subsystems.fcs.errors.ReadingADCError;

public class CanOpenProxy
extends Module {
    private ApcTcpProxy tcpProxy;
    private String myClientName = "CanOpenProxy";
    private int nodeNB = 2;
    private int bootednodeNB = 0;
    private int infoNB = 0;
    private CanOpenNode[] nodes = new CanOpenNode[this.nodeNB];
    private boolean hardwareBooted = false;
    private boolean adcInitialized = false;

    public ApcTcpProxy getTcpProxy() {
        return this.tcpProxy;
    }

    public void setTcpProxy(ApcTcpProxy myTcpProxy) {
        this.tcpProxy = myTcpProxy;
    }

    public String getMyClientName() {
        return this.myClientName;
    }

    public void setMyClientName(String myClientName) {
        this.myClientName = myClientName;
    }

    public void initModule() {
        this.nodes = new CanOpenNode[this.nodeNB];
    }

    public void tick() {
        if (!this.hardwareBooted && this.tcpProxy.isReady(this.myClientName)) {
            try {
                this.bootHardware();
            }
            catch (BootingHardwareError ex) {
                Logger.getLogger(CanOpenProxy.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.hardwareBooted && !this.adcInitialized) {
            try {
                this.initADC(1, 1);
                this.adcInitialized = true;
                Module.log.debug((Object)"ADC is initialized");
            }
            catch (ReadingADCError ex) {
                Logger.getLogger(CanOpenProxy.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (HardwareNotBootedError ex) {
                Logger.getLogger(CanOpenProxy.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void bootHardware() throws BootingHardwareError {
        while (this.bootednodeNB < this.nodeNB || this.infoNB < this.nodeNB) {
            String bootLine = this.tcpProxy.readFromSocket(this.myClientName);
            String[] words = bootLine.split(",");
            String command = words[0];
            int nodeID = Integer.parseInt(words[1]);
            Module.log.debug((Object)("Received on socket command = " + command + "," + nodeID));
            if (command.equals("boot")) {
                this.nodes[this.bootednodeNB] = new CanOpenNode(nodeID);
                ++this.bootednodeNB;
                Module.log.debug((Object)("Node " + nodeID + " added"));
                Module.log.debug((Object)("Hardware booted nb=" + this.bootednodeNB));
                continue;
            }
            if (!command.equals("info")) continue;
            int type = Integer.parseInt(words[2]);
            int vendor = Integer.parseInt(words[3]);
            int productCode = Integer.parseInt(words[4]);
            int revision = Integer.parseInt(words[5]);
            this.addNodeInfo(nodeID, type, vendor, productCode, revision);
            ++this.infoNB;
            Module.log.debug((Object)("Node Info" + nodeID + " added"));
        }
        if (this.bootednodeNB != this.nodeNB || this.infoNB != this.nodeNB) {
            throw new BootingHardwareError(this.myClientName);
        }
        this.hardwareBooted = true;
    }

    private void addNodeInfo(int nodeID, int type, int vendor, int productCode, int revision) throws BootingHardwareError {
        boolean nodeFound = false;
        int i = 0;
        while (i < this.nodes.length) {
            if (this.nodes[i] != null && this.nodes[i].getNodeID() == nodeID) {
                this.nodes[i].setNodeInfo(type, vendor, productCode, revision);
                nodeFound = true;
            }
            ++i;
        }
        if (!nodeFound) {
            throw new BootingHardwareError(this.myClientName, nodeID);
        }
    }

    public String listNodes() {
        StringBuilder sb = new StringBuilder("Nodes LIST = ");
        int i = 0;
        while (i < this.nodes.length) {
            sb.append("\n");
            sb.append(this.nodes[i].toString());
            ++i;
        }
        Module.log.debug((Object)sb.toString());
        return sb.toString();
    }

    private void initADC(int nodeID, int syncNB) throws ReadingADCError, HardwareNotBootedError {
        if (!this.hardwareBooted) {
            throw new HardwareNotBootedError();
        }
        String canOpenCommand1 = CanOpenProxy.buildCanOpenCommand("wsdo", nodeID, 1801, 2, 1, 1);
        Object ack = this.getTcpProxy().call(this.getMyClientName(), canOpenCommand1);
        if (!(ack instanceof String)) {
            throw new ReadingADCError(ack);
        }
        Module.log.debug((Object)("initADC-step1 = " + ack));
        String canOpenCommand2 = CanOpenProxy.buildCanOpenCommand("wsdo", nodeID, 1802, 2, 1, 1);
        Object ack2 = this.getTcpProxy().call(this.getMyClientName(), canOpenCommand2);
        Module.log.debug((Object)("initADC-step2 = " + ack2));
    }

    private Object sendCanOpen(String command) {
        return this.getTcpProxy().call(this.getMyClientName(), command);
    }

    public void stop() {
        this.getTcpProxy().stop();
    }

    private static String buildCanOpenCommand(String command, int nodeID, int index, int subindex, int size, int data) {
        StringBuilder sb = new StringBuilder(command);
        String sep = ",";
        sb.append(sep);
        sb.append(nodeID);
        sb.append(sep);
        sb.append(index);
        sb.append(sep);
        sb.append(subindex);
        sb.append(sep);
        sb.append(size);
        sb.append(sep);
        sb.append(data);
        return sb.toString();
    }

    int readADC(int nodeID, int inputID, int index, int subindex) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    int writeDAC(int nodeID, int inputID, int index, int subindex, int value) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

