/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.subsystems.fcs.CarouselModule;

public class StatusDataPublishedByCarousel
implements Serializable {
    private static final long serialVersionUID = 7037058370873652888L;
    private double rotationInDegrees = 0.0;
    private boolean isLocked = false;
    private String[] filterNames;
    private String filterInStandbyName;
    private String[] clampsInfo;
    private String actuatorXminusState;
    private String actuatorXplusState;

    StatusDataPublishedByCarousel(int nbSockets) {
        this.filterNames = new String[nbSockets];
        int i = 0;
        while (i < this.filterNames.length) {
            this.filterNames[i] = "";
            ++i;
        }
        this.filterInStandbyName = "none";
        this.clampsInfo = new String[nbSockets];
        this.actuatorXminusState = null;
        this.actuatorXplusState = null;
    }

    public void update(CarouselModule carousel) {
        this.rotationInDegrees = carousel.getPosition();
        this.isLocked = carousel.isLocked();
        this.filterNames = new String[carousel.nbSockets];
        int i = 0;
        while (i < this.filterNames.length) {
            this.filterNames[i] = carousel.getSockets()[i].getFilter() == null ? "empty" : carousel.getSockets()[i].getFilter().getName();
            ++i;
        }
        this.filterInStandbyName = carousel.getFilterInStandbyName();
        i = 0;
        while (i < carousel.nbSockets) {
            StringBuilder sb = new StringBuilder("Socket number: ");
            sb.append(i).append("\n");
            sb.append(carousel.getSockets()[i].toString());
            this.clampsInfo[i] = sb.toString();
            ++i;
        }
        this.actuatorXminusState = carousel.getClampActuatorXminus().toString();
        this.actuatorXplusState = carousel.getClampActuatorXplus().toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Carousel POSITION = ");
        sb.append(this.rotationInDegrees);
        sb.append("; carousel is locked=");
        sb.append(this.isLocked);
        sb.append(";\n Filters on carousel:\n");
        int i = 0;
        while (i < this.filterNames.length) {
            if (this.filterNames[i] == "empty") {
                sb.append("socket ");
                sb.append(i);
                sb.append(" is empty;");
            } else {
                sb.append(this.filterNames[i]);
                sb.append(" is on socket number ");
                sb.append(i);
                sb.append(";");
            }
            ++i;
        }
        sb.append("\n Filter in Standby position= ");
        sb.append(this.filterInStandbyName).append("\n");
        i = 0;
        while (i < this.clampsInfo.length) {
            sb.append(this.clampsInfo[i]);
            ++i;
        }
        return sb.toString();
    }

    public String getFilterInStandbyName() {
        return this.filterInStandbyName;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public double getRotationInDegrees() {
        return this.rotationInDegrees;
    }
}

