/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.common.FlipRail;
import org.lsst.ccs.subsystems.fcs.common.FlipRailState;

public class FlipRailModule
extends Module
implements FlipRail {
    private static final long serialVersionUID = 5211766913111710943L;
    FlipRailState state;
    Actuator actuator;
    String stateOutputName = "Flip Rail State";
    private double trucksPositionMin = 30.0;

    @Override
    public synchronized String close() throws ErrorInCommandExecutionException {
        Module.log.info((Object)(String.valueOf(this.getName()) + ": closing "));
        this.actuator.on();
        this.setState(FlipRailState.CLOSED);
        if (!this.state.equals((Object)FlipRailState.CLOSED)) {
            throw new ErrorInCommandExecutionException("Error in execution of command close for " + this.getName());
        }
        this.sendToReply(new CommandReply((Object)"Fliprail is closed", CommandReply.CommandStatus.OK));
        return String.valueOf(this.getName()) + " closed";
    }

    @Override
    public synchronized String open() throws ErrorInCommandExecutionException, BadCommandException {
        if (this.getAutochangerTrucksPosition() < this.trucksPositionMin) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": unable to open because autochanger truck is on the way.");
        }
        Module.log.info((Object)(String.valueOf(this.getName()) + ": opening "));
        this.actuator.off();
        this.setState(FlipRailState.OPEN);
        if (!this.state.equals((Object)FlipRailState.OPEN)) {
            throw new ErrorInCommandExecutionException("Error in execution of command open for " + this.getName());
        }
        this.sendToReply(new CommandReply((Object)"Fliprail is open", CommandReply.CommandStatus.OK));
        return String.valueOf(this.getName()) + " open";
    }

    @Override
    public void goHome() {
    }

    public void initModule() {
        Module.log.info((Object)"[FlipRailModule] Initializing the Flip Rail  module ");
        try {
            this.goHome();
            this.setState(FlipRailState.OPEN);
        }
        catch (RuntimeException e) {
            Module.log.fatal((Object)("[Flip RAil Module] ERROR: " + this.name + " Initialization failed for Flip Rail module : " + e.getMessage()));
            throw e;
        }
    }

    public void tick() {
        try {
            this.setChanged();
            this.notifyObservers(new Module.ValueUpdate((Module)this, this.stateOutputName, (Object)this.getState()));
        }
        catch (Exception e) {
            Module.log.error((Object)e);
        }
    }

    public String stop() {
        return String.valueOf(this.getName()) + ": stopped";
    }

    private double getAutochangerTrucksPosition() {
        AutoChangerModule autochanger = (AutoChangerModule)this.getModule("autochanger");
        return autochanger.getTrucksPosition();
    }

    @Override
    public FlipRailState getState() {
        return this.state;
    }

    public void setState(FlipRailState state) {
        this.state = state;
    }

    public Actuator getActuator() {
        return this.actuator;
    }

    public void setActuator(Actuator actuator) {
        this.actuator = actuator;
    }
}

