/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.common.Latch;
import org.lsst.ccs.subsystems.fcs.common.Sensor;

public class FilterLatchModule
extends Module
implements Latch {
    Actuator actuator;
    Sensor presenceFilterSensor;
    Sensor lockSensor;
    Sensor unlockSensor;

    @Override
    public boolean isInError() {
        return this.isLocked() && this.isUnlocked();
    }

    @Override
    public String unlock() throws BadCommandException, ErrorInCommandExecutionException {
        if (!this.isLocked()) {
            throw new BadCommandException("");
        }
        this.actuator.on();
        try {
            this.updateStateWithSensors();
            while (this.isLocked()) {
                Thread.sleep(this.tickMillis);
                this.updateStateWithSensors();
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FilterLatchModule.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (LatchError err) {
            Logger.getLogger(FilterLatchModule.class.getName()).log(Level.SEVERE, null, err);
        }
        if (this.isLocked() || this.isInError()) {
            throw new ErrorInCommandExecutionException("");
        }
        return String.valueOf(this.getName()) + "Unlocked";
    }

    @Override
    public String lock() throws BadCommandException, ErrorInCommandExecutionException {
        if (!this.isUnlocked()) {
            throw new BadCommandException("");
        }
        this.actuator.off();
        try {
            this.updateStateWithSensors();
            while (this.isUnlocked()) {
                Thread.sleep(this.tickMillis);
                this.updateStateWithSensors();
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FilterLatchModule.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (LatchError err) {
            Logger.getLogger(FilterLatchModule.class.getName()).log(Level.SEVERE, null, err);
        }
        if (this.isUnlocked() || this.isInError()) {
            throw new ErrorInCommandExecutionException("");
        }
        return String.valueOf(this.getName()) + ": Locked";
    }

    @Override
    public boolean isLocked() {
        return this.lockSensor.getValue() == 1;
    }

    @Override
    public boolean isUnlocked() {
        return this.unlockSensor.getValue() == 1;
    }

    private void updateStateWithSensors() throws LatchError {
        this.presenceFilterSensor.updateValue();
        this.lockSensor.updateValue();
        this.unlockSensor.updateValue();
        if (this.isInError()) {
            throw new LatchError(String.valueOf(this.getName()) + "lock status sensors disagree", this);
        }
    }

    private static class LatchError
    extends Exception {
        FilterLatchModule latch;

        public LatchError(String string, FilterLatchModule aThis) {
            super(string);
            this.latch = aThis;
        }
    }
}

