/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.common.FilterClamp;
import org.lsst.ccs.subsystems.fcs.common.FilterClampState;
import org.lsst.ccs.subsystems.fcs.common.FilterPresenceStateOnClamp;
import org.lsst.ccs.subsystems.fcs.common.Sensor12bits;
import org.lsst.ccs.subsystems.fcs.errors.SensorValueOutOfRangeException;

public abstract class FilterClampModule
extends Module
implements FilterClamp {
    protected FilterClampState state;
    protected FilterPresenceStateOnClamp filterPresence;
    private Sensor12bits filterPresenceSensor;
    private int valueA;
    private int valueB;
    private int valueC;
    public String publishedByClampOutputName = "publishedByClamp";
    public StatusDataPublishedByClamp publishedByClamp;
    private volatile boolean updateCompleted = true;

    public void setValueA(int valueA) {
        this.valueA = valueA;
    }

    public void setValueB(int valueB) {
        this.valueB = valueB;
    }

    public void setValueC(int valueC) {
        this.valueC = valueC;
    }

    @Override
    public FilterClampState getState() {
        return this.state;
    }

    @Override
    public void setState(FilterClampState state) {
        this.state = state;
    }

    protected boolean isUpdateCompleted() {
        return this.updateCompleted;
    }

    protected void setUpdateCompleted(boolean updateCompleted) {
        this.updateCompleted = updateCompleted;
    }

    public int getValueA() {
        return this.valueA;
    }

    public int getValueB() {
        return this.valueB;
    }

    public int getValueC() {
        return this.valueC;
    }

    @Override
    public Sensor12bits getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    public void setFilterPresenceSensor(Sensor12bits filterPresenceSensor) {
        this.filterPresenceSensor = filterPresenceSensor;
    }

    @Override
    public synchronized boolean isFilterEngaged() {
        return this.filterPresence.equals((Object)FilterPresenceStateOnClamp.ENGAGED);
    }

    @Override
    public abstract boolean isLocked();

    @Override
    public synchronized void updateStateWithSensors() {
        this.setUpdateCompleted(false);
        this.filterPresenceSensor.updateValue();
        if (this.filterPresenceSensor.getValue() >= this.getValueC()) {
            this.filterPresence = FilterPresenceStateOnClamp.NOFILTER;
        } else if (this.filterPresenceSensor.getValue() >= this.getValueB()) {
            this.filterPresence = FilterPresenceStateOnClamp.UNKNOWN;
        } else if (this.filterPresenceSensor.getValue() >= this.getValueA()) {
            this.filterPresence = FilterPresenceStateOnClamp.ENGAGED;
        } else {
            try {
                throw new SensorValueOutOfRangeException(this.filterPresenceSensor, this.filterPresenceSensor.getValue());
            }
            catch (SensorValueOutOfRangeException ex) {
                Logger.getLogger(FilterClampModule.class.getName()).log(Level.SEVERE, "should not append", ex);
            }
        }
        this.state = this.filterPresence.equals((Object)FilterPresenceStateOnClamp.ENGAGED) ? (this.isLocked() ? FilterClampState.CLAMPEDONFILTER : FilterClampState.UNCLAMPEDONFILTER) : (this.isLocked() ? FilterClampState.READYTOCLAMP : FilterClampState.UNCLAMPEDEMPTY);
        this.setUpdateCompleted(true);
    }

    public synchronized void tick() {
        this.updateStateWithSensors();
        Module.log.debug((Object)(String.valueOf(this.getName()) + " : filterPresence =" + this.filterPresence.toString()));
        this.publishedByClamp.update(this);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.publishedByClampOutputName, (Object)this.publishedByClamp));
    }

    public void initModule() {
        this.initPublishedData();
        this.filterPresence = FilterPresenceStateOnClamp.UNKNOWN;
    }

    public void initPublishedData() {
        this.publishedByClamp = new StatusDataPublishedByClamp();
    }

    @Override
    public StatusDataPublishedByClamp getStatusData() {
        this.publishedByClamp.update(this);
        return this.publishedByClamp;
    }

    @Override
    public String release(Actuator actuator) throws BadCommandException, ErrorInCommandExecutionException {
        this.updateStateWithSensors();
        if (!this.state.equals(FilterClampState.UNCLAMPEDEMPTY)) {
            throw new BadCommandException("Can't release a clamp if isn't unclamped and empty.");
        }
        actuator.off();
        while (this.state.equals(FilterClampState.UNCLAMPEDEMPTY)) {
            try {
                Thread.sleep(this.tickMillis);
                this.updateStateWithSensors();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FilterClampModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.state.equals(FilterClampState.READYTOCLAMP)) {
            return String.valueOf(this.getName()) + " is released";
        }
        throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": Could not release clamp.");
    }

    @Override
    public String unlock(Actuator actuator) throws BadCommandException, ErrorInCommandExecutionException {
        Module.log.debug((Object)(String.valueOf(this.getName()) + "State1 = " + this.state.toString()));
        this.updateStateWithSensors();
        if (!this.state.equals(FilterClampState.CLAMPEDONFILTER)) {
            throw new BadCommandException("Can't unlock a clamp if isn't clamped on filter.");
        }
        actuator.on();
        while (this.state.equals(FilterClampState.CLAMPEDONFILTER)) {
            try {
                Thread.sleep(this.tickMillis);
                this.updateStateWithSensors();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FilterClampModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Module.log.debug((Object)(String.valueOf(this.getName()) + "State2 = " + this.state.toString()));
        if (this.state.equals(FilterClampState.UNCLAMPEDONFILTER)) {
            return String.valueOf(this.getName()) + " is unlocked";
        }
        throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": Could not unlock clamp.");
    }
}

