/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.common.FilterClamp;
import org.lsst.ccs.subsystems.fcs.common.FilterClampState;
import org.lsst.ccs.subsystems.fcs.common.FilterLocation;
import org.lsst.ccs.subsystems.fcs.errors.HardwareErrorDetectedException;

public class CarouselSocket {
    private FilterClamp clampXminus;
    private FilterClamp clampXplus;
    private double position;
    private double standbyPosition;
    private Filter filter;
    private int tickMillis = 500;

    public CarouselSocket() {
    }

    public CarouselSocket(double position) {
        this.position = position;
        this.standbyPosition = position == 0.0 ? 0.0 : 360.0 - position;
    }

    public FilterClamp getClampXminus() {
        return this.clampXminus;
    }

    public void setClampXminus(FilterClamp clampXminus) {
        this.clampXminus = clampXminus;
    }

    public FilterClamp getClampXplus() {
        return this.clampXplus;
    }

    public synchronized void setClampXplus(FilterClamp clampXplus) {
        this.clampXplus = clampXplus;
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double position) {
        this.position = position;
    }

    public Filter getFilter() {
        return this.filter;
    }

    protected void setFilter(Filter filter) {
        this.filter = filter;
    }

    public double getStandbyPosition() {
        return this.standbyPosition;
    }

    public void setStandbyPosition(double standbyPosition) {
        this.standbyPosition = standbyPosition;
    }

    public synchronized boolean isEmpty() throws HardwareErrorDetectedException {
        if (this.clampXminus.isFilterEngaged() && this.clampXplus.isFilterEngaged()) {
            return false;
        }
        if (!this.clampXminus.isFilterEngaged() && !this.clampXplus.isFilterEngaged()) {
            return true;
        }
        throw new HardwareErrorDetectedException("Error in filter presence detection at standby position : the clamps don't agree.");
    }

    public synchronized boolean isClampedOnFilter() {
        return this.clampXminus.getState().equals(FilterClampState.CLAMPEDONFILTER) && this.clampXplus.getState().equals(FilterClampState.CLAMPEDONFILTER);
    }

    boolean isUnclampedOnFilter() {
        return this.clampXminus.getState().equals(FilterClampState.UNCLAMPEDONFILTER) && this.clampXplus.getState().equals(FilterClampState.UNCLAMPEDONFILTER);
    }

    public synchronized boolean isUnclampedEmpty() {
        return this.clampXminus.getState().equals(FilterClampState.UNCLAMPEDEMPTY) && this.clampXplus.getState().equals(FilterClampState.UNCLAMPEDEMPTY);
    }

    public synchronized boolean isReadyToClamp() {
        return this.clampXminus.getState().equals(FilterClampState.READYTOCLAMP) && this.clampXplus.getState().equals(FilterClampState.READYTOCLAMP);
    }

    public synchronized boolean isUpdatedCompleted() {
        return ((FilterClampModule)this.getClampXminus()).isUpdateCompleted() && ((FilterClampModule)this.getClampXplus()).isUpdateCompleted();
    }

    public synchronized void updateClampsStateWithSensors() {
        ((FilterClampModule)this.getClampXminus()).setUpdateCompleted(false);
        ((FilterClampModule)this.getClampXplus()).setUpdateCompleted(false);
        this.getClampXminus().updateStateWithSensors();
        this.getClampXplus().updateStateWithSensors();
        while (!this.isUpdatedCompleted()) {
            try {
                this.wait(this.tickMillis);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(CarouselSocket.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void removeFilter() throws BadCommandException {
        if (this.filter == null) {
            throw new BadCommandException("Carousel socket : there is no filter to remove at standby position");
        }
        this.filter = null;
    }

    public synchronized void putFilterOnSocket(Filter filter) {
        this.setFilter(filter);
        filter.setFilterLocation(FilterLocation.ONCAROUSEL);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("Filter in socket : ");
        if (this.getFilter() == null) {
            sb.append(" NO FILTER").append("\n");
        } else {
            sb.append(this.getFilter().getName()).append("\n");
        }
        sb.append(this.clampXminus.getStatusData().toString()).append("\n");
        sb.append(this.clampXplus.getStatusData().toString()).append("\n");
        return sb.toString();
    }
}

