/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.common.AutoChanger;
import org.lsst.ccs.subsystems.fcs.common.FilterLocation;
import org.lsst.ccs.subsystems.fcs.common.Latch;
import org.lsst.ccs.subsystems.fcs.common.ModuleState;

public abstract class BasicAutoChangerModule
extends Module
implements AutoChanger {
    private boolean isEmpty;
    Filter filterOnTrucks;
    private Latch latchXminus;
    private Latch latchXplus;
    public static String publishedByAutoChangerOutputName = "publishedByAutoChanger";
    private StatusDataPublishedByBasicAutoChanger publishedByBasicAutoChanger;
    protected volatile ModuleState state = ModuleState.HALTED;

    @Override
    public Filter getFilterOnTrucks() {
        return this.filterOnTrucks;
    }

    public String getFilterOnTrucksName() {
        if (this.filterOnTrucks == null) {
            return "none";
        }
        return this.filterOnTrucks.getName();
    }

    public StatusDataPublishedByBasicAutoChanger getStatusData() {
        this.publishedByBasicAutoChanger.update(this);
        return this.publishedByBasicAutoChanger;
    }

    public ModuleState getState() {
        return this.state;
    }

    public void setState(ModuleState state) {
        this.state = state;
    }

    @Override
    public abstract String goToPosition(double var1) throws IllegalArgumentException, BadCommandException;

    public abstract String goToStandby();

    public String goToStandback() {
        return null;
    }

    @Override
    public String grabbeFilterAtStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException {
        if (this.filterOnTrucks != null) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": can't grabbe a filter " + "when a filter is already loaded in trucks ");
        }
        Module.log.info((Object)(String.valueOf(this.getName()) + ": grabbing " + filter.getName() + " at standby position."));
        this.unlockLatchesAtStandby();
        this.goToStandby();
        this.lockLatchesAtStandby(filter);
        String ack = String.valueOf(this.getName()) + ": " + filter.getName() + " is grabbed on autochanger";
        Module.log.info((Object)ack);
        return ack;
    }

    public void initModule() {
        Module.log.info((Object)"[AutoChangerModule] Initializing the Auto Changer module ");
        this.initPublishedData();
    }

    @Override
    public void initPublishedData() {
        this.publishedByBasicAutoChanger = new StatusDataPublishedByBasicAutoChanger();
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public abstract boolean isMoving();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lockLatchesAtStandby(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException {
        try {
            this.latchXminus.lock();
            this.latchXplus.lock();
            while (!this.latchXminus.isLocked() || !this.latchXplus.isLocked()) {
                try {
                    Module.log.info((Object)"Waiting for the AutoChanger latches to be locked on the filter.");
                    Thread.sleep(this.tickMillis);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(BasicAutoChangerModule.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.latchXminus.isLocked() && this.latchXplus.isLocked()) {
                Module.log.info((Object)"Filter is now locked on auto-changer trucks.");
                BasicAutoChangerModule ex = this;
                synchronized (ex) {
                    this.filterOnTrucks = aFilter;
                    this.setEmpty(false);
                    aFilter.setFilterLocation(FilterLocation.ONAUTOCHANGER);
                    this.updatePublishedDataAndNotifyObservers();
                }
            } else {
                throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": standby latches couldn't be locked.");
            }
            String ack = String.valueOf(this.getName()) + ": standby latches are locked";
            Module.log.info((Object)ack);
            return ack;
        }
        catch (BadCommandException ex) {
            Logger.getLogger(BasicAutoChangerModule.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public abstract String moveFilterToOnline(Filter var1) throws BadCommandException, ErrorInCommandExecutionException;

    @Override
    public abstract String moveFilterToStandby(Filter var1) throws BadCommandException, ErrorInCommandExecutionException;

    public abstract String moveFilterToStandback(Filter var1) throws BadCommandException, ErrorInCommandExecutionException;

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        this.updatePublishedDataAndNotifyObservers();
    }

    public void setEmpty(boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    public void setFilterOnTrucks(Filter filterOnTrucks) {
        this.filterOnTrucks = filterOnTrucks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\n");
        sb.append("Trucks position = ");
        sb.append("Filter on trucks:");
        if (this.filterOnTrucks == null) {
            sb.append(" NONE").append("\n");
        } else {
            sb.append(this.filterOnTrucks.getName()).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String unGrabbeFilterAtStandby() throws ErrorInCommandExecutionException, BadCommandException {
        Module.log.info((Object)(String.valueOf(this.getName()) + ": ungrabbing filter at standby position."));
        this.unlockLatchesAtStandby();
        BasicAutoChangerModule basicAutoChangerModule = this;
        synchronized (basicAutoChangerModule) {
            this.filterOnTrucks = null;
            this.setEmpty(true);
            this.updatePublishedDataAndNotifyObservers();
        }
        Module.log.info((Object)(String.valueOf(this.getName()) + " trucks going empty to SWAPOUT position"));
        this.goToStandback();
        String ack = String.valueOf(this.getName()) + ": trucks are empty at SWAPOUT position ";
        return ack;
    }

    @Override
    public String unlockLatchesAtStandby() throws BadCommandException, ErrorInCommandExecutionException {
        try {
            this.latchXminus.unlock();
            this.latchXplus.unlock();
            if (this.latchXminus.isLocked() || this.latchXplus.isLocked()) {
                throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": standby latches could not be unlocked.");
            }
            String ack = String.valueOf(this.getName()) + ": standby latches are unlocked";
            Module.log.info((Object)ack);
            return ack;
        }
        catch (BadCommandException ex) {
            Logger.getLogger(BasicAutoChangerModule.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void updatePublishedDataAndNotifyObservers() {
        this.publishedByBasicAutoChanger.update(this);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, publishedByAutoChangerOutputName, (Object)this.publishedByBasicAutoChanger));
    }
}

