/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.FcsMainModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FlipRailModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.common.EngineState;
import org.lsst.ccs.subsystems.fcs.common.FlipRailState;
import org.lsst.ccs.subsystems.fcs.common.Latch;
import org.lsst.ccs.subsystems.fcs.common.ModuleState;
import org.lsst.ccs.subsystems.fcs.common.Motor;

public class AutoChangerModule
extends BasicAutoChangerModule {
    private static final long serialVersionUID = -3737919230282962231L;
    private FlipRailModule fliprail;
    private Latch onlineClamp;
    private StatusDataPublishedByAutoChanger publishedByAutoChanger;
    private double trucksPositionOnline;
    private double trucksPositionAtStandby;
    private double trucksPositionSwapout;
    Motor motor;

    @Override
    public void initModule() {
        Module.log.info((Object)"[AutoChangerModule] Initializing the Auto Changer module ");
        this.setState(ModuleState.HALTED);
        this.initPublishedData();
        this.motor.setMinimalPosition(this.getTrucksPositionAtStandby());
        this.motor.setMaximalPosition(this.getTrucksPositionOnline());
    }

    @Override
    public StatusDataPublishedByAutoChanger getStatusData() {
        this.publishedByAutoChanger.update(this);
        return this.publishedByAutoChanger;
    }

    @Override
    public void initPublishedData() {
        this.publishedByAutoChanger = new StatusDataPublishedByAutoChanger();
    }

    private boolean isAbleToMove() {
        return this.getFliprail().state.equals((Object)FlipRailState.CLOSED) && !this.onlineClamp.isLocked();
    }

    private Filter getFilterAtStandbyOnCarousel() {
        return ((FcsMainModule)this.getModule("main")).getFilterAtStandby();
    }

    public String closeOnlineClamp() throws ErrorInCommandExecutionException {
        if (!this.onlineClamp.isLocked()) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + "online clamp couldn't be closed.");
        }
        String ack = String.valueOf(this.getName()) + ": online clamp closed";
        Module.log.info((Object)ack);
        return ack;
    }

    public String openOnlineClamp() throws ErrorInCommandExecutionException {
        if (this.onlineClamp.isLocked()) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + "online clamp couldn't be open.");
        }
        String ack = String.valueOf(this.getName()) + ": online clamp open";
        Module.log.info((Object)ack);
        return ack;
    }

    public String openFliprail() throws ErrorInCommandExecutionException, BadCommandException {
        return this.getFliprail().open();
    }

    public String closeFliprail() throws ErrorInCommandExecutionException {
        return this.getFliprail().close();
    }

    public Latch getOnlineClamp() {
        return this.onlineClamp;
    }

    public void setOnlineClamp(Latch onlineClamp) {
        this.onlineClamp = onlineClamp;
    }

    public FlipRailModule getFliprail() {
        return this.fliprail;
    }

    public FlipRailState getFlipRailState() {
        return this.getFliprail().state;
    }

    public void setFliprail(FlipRailModule fliprail) {
        this.fliprail = fliprail;
    }

    @Override
    public void updatePublishedDataAndNotifyObservers() {
        this.publishedByAutoChanger.update(this);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, BasicAutoChangerModule.publishedByAutoChangerOutputName, (Object)this.publishedByAutoChanger));
    }

    @Override
    public String goToPosition(double requiredPosition) throws IllegalArgumentException, BadCommandException {
        String message = null;
        if (requiredPosition > this.getTrucksPositionOnline() || requiredPosition < this.getTrucksPositionAtStandby()) {
            throw new IllegalArgumentException("Please enter a position between " + this.getTrucksPositionAtStandby() + " and " + this.getTrucksPositionOnline());
        }
        if (this.isMoving()) {
            message = "Auto-changer is moving, stop it before sending a new motion command.";
            Module.log.error((Object)message);
            throw new BadCommandException(message);
        }
        if (!this.isAbleToMove()) {
            message = "Auto-changer is unable to move because fliprail is open or online clamp is locked.";
            Module.log.error((Object)message);
            throw new BadCommandException(message);
        }
        this.setState(ModuleState.RUNNING);
        this.motor.setRequiredPosition(requiredPosition);
        Module.log.info((Object)(String.valueOf(this.getName()) + " is moving to position: " + requiredPosition));
        Module.log.info((Object)"Please wait during auto-changer motion...");
        message = "Moving to required position: " + requiredPosition;
        double displacement = requiredPosition - this.getTrucksPosition();
        this.motor.move(displacement);
        Module.log.info((Object)("AutoChanger moving to required position: " + requiredPosition + ", please wait..."));
        while (this.isMoving()) {
            try {
                Module.log.info((Object)"...auto-changer moving, please wait.....");
                Module.log.info((Object)(String.valueOf(this.getName()) + " WAITING TO BE AT REQUIRED POSITION=" + requiredPosition));
                Module.log.info((Object)this.state.toString());
                Thread.sleep(this.tickMillis);
            }
            catch (InterruptedException interruptedException) {
                return "Sleeping interrupted";
            }
        }
        if (!this.isMoving()) {
            Module.log.info((Object)("THREAD=" + Thread.currentThread().getName()));
            this.state = ModuleState.HALTED;
            Module.log.info((Object)"auto-changer is now halted.");
            Module.log.info((Object)("filter on truck: " + this.getFilterOnTrucksName()));
            if (this.getTrucksPosition() == requiredPosition) {
                message = "goToPosition command completed";
                Module.log.info((Object)message);
            } else {
                message = "goToPosition command non completed: auto-changer is not stopped at the required position";
                Module.log.info((Object)message);
            }
        }
        Module.log.error((Object)message);
        return message;
    }

    @Override
    public String stop() {
        String message;
        if (this.isMoving()) {
            message = "Stopping auto-changer";
            this.motor.stop();
            this.state = ModuleState.HALTED;
        } else {
            message = "Auto-changer is already stopped";
        }
        return message;
    }

    @Override
    public String moveFilterToOnline(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException {
        if (this.isEmpty()) {
            throw new BadCommandException("Autochanger is empty");
        }
        if (this.getTrucksPosition() == this.getTrucksPositionOnline()) {
            throw new BadCommandException("Filter " + aFilter.getName() + " is already at online position.");
        }
        this.closeFliprail();
        this.goToPosition(this.getTrucksPositionOnline());
        if (this.getTrucksPosition() == this.getTrucksPositionOnline()) {
            Module.log.info((Object)(String.valueOf(this.getName()) + ": " + aFilter.getName() + " is at online position"));
            this.closeOnlineClamp();
            return this.openFliprail();
        }
        Module.log.error((Object)"");
        return null;
    }

    @Override
    public String moveFilterToStandby(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException {
        if (this.isEmpty()) {
            throw new BadCommandException("Autochanger is empty");
        }
        if (this.getTrucksPosition() == this.getTrucksPositionAtStandby()) {
            throw new BadCommandException("Filter " + this.filterOnTrucks.getName() + " is already at standby position.");
        }
        this.closeFliprail();
        this.openOnlineClamp();
        this.goToPosition(this.getTrucksPositionAtStandby());
        if (this.getTrucksPosition() == this.getTrucksPositionAtStandby()) {
            Module.log.info((Object)(String.valueOf(this.getName()) + ": " + this.filterOnTrucks.getName() + " is at standby position."));
            return String.valueOf(this.getName()) + ": " + this.filterOnTrucks.getName() + " is at standby position.";
        }
        String message = "the autochanger truck is not at the required position.";
        Module.log.error((Object)message);
        throw new ErrorInCommandExecutionException(message);
    }

    @Override
    public String goToStandby() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String moveFilterToStandback(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String moveFilterToStandby() throws BadCommandException, ErrorInCommandExecutionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Filter getFilterOnline() {
        if (this.getTrucksPosition() == this.getTrucksPositionOnline() && !this.isMoving()) {
            return this.filterOnTrucks;
        }
        return null;
    }

    public String getFilterOnlineName() {
        if (this.getFilterOnline() == null) {
            return "none";
        }
        return this.getFilterOnline().getName();
    }

    @Override
    public double getTrucksPosition() {
        return this.motor.getPosition();
    }

    public double getTrucksPositionAtStandby() {
        return this.trucksPositionAtStandby;
    }

    public double getTrucksPositionOnline() {
        return this.trucksPositionOnline;
    }

    public double getTrucksPositionSwapout() {
        return this.trucksPositionSwapout;
    }

    @Override
    public synchronized void locateTrucks() {
        this.filterOnTrucks = null;
        this.setEmpty(true);
    }

    public void setTrucksPositionAtStandby(double trucksPositionAtStandby) {
        this.trucksPositionAtStandby = trucksPositionAtStandby;
    }

    public void setTrucksPositionOnline(double trucksPositionOnline) {
        this.trucksPositionOnline = trucksPositionOnline;
    }

    public void setTrucksPositionSwapout(double trucksPositionSwapout) {
        this.trucksPositionSwapout = trucksPositionSwapout;
    }

    public Motor getMotor() {
        return this.motor;
    }

    public void setMotor(Motor motor) {
        this.motor = motor;
    }

    @Override
    public boolean isMoving() {
        return this.motor.getEngineState().equals(EngineState.RUNNING);
    }
}

