/**
 * This package is for the test bench installed at <a href="http://www.apc.univ-paris7.fr/APC_CS/">APC</a> 
 * with a PC104 and two Can Open Devices : an ADC and a DAC.
 * 
 * Its purpose is to test the communications between the CCS and the control software of the test bench.
 * The control software of the test bench has 2 parts :
 * - a Modular Subsystem, which is a subsystem of the CCS and written with the CCS framework
 * - a C program which handle the can open devices : it translate the commands comming from the Modular 
 * Subsystem in commands that the ADC and the DAC can understand. To do this translation, it uses 
 * the open source <a ref="http://canfestival.org/">C library canfestival.</a>.
 * 
 * The PC104 has 2 can bus interfaces and is connected to one or two Can Open device.
 * The PC104 with its can bus interfaces is a Can Open Master Device and the 2 other devices on the Can Bus
 * are Can OPen Slave Can Open Device.
 * 
 * The APC test bench is made of one PC104 and 2 can open devives :
 * - a 8 analog inputs (CAN_CBX_AI814)
 * - a 4 analog outputs (CAN_CBX_AO412)
 * A thermometer is connected to the analog inputs and a led is connected to the 
 * analog output.
 * One of the OUTPUT of the DAC is connected to the INPUT of the APC, so we can test if the value we write on the 
 * DAC is the same value we read on the ADC
 * With the TestBenchMainModule, we can read the temperature, turn on or off the led
 * or start an automatic mode where the temperature is read every tickmillis seconds.
 * When the temperature reachs a given value, it turns the led on, otherwise, 
 * it turns the led off.
 * 
 * This package should not survive after camera construction.
 * 
 * The communications with the Can OPen devices are done by the C programm, testadcdac, which 
 * relies on the canfestival C-library. The Wrapper and the TestBenchMainModule 
 * communicates over a TCPIP connection.
 * 
 */
package org.lsst.ccs.subsystems.fcs.testbench;
