/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import com.sun.jna.Library;
import com.sun.jna.Native;

/**
 * Just for testing JNA : a better solution is to do the job in a C file
 * and communicate to this C file with a TCP proxy.
 * @author virieux
 */
public class TestCanfestival {
    
    public interface CanFestivalLibrary extends Library {
    
        CanFestivalLibrary INSTANCE = (CanFestivalLibrary) Native.loadLibrary("canfestival_can_virtual", CanFestivalLibrary.class);
        CanFestivalLibrary INSTANCE2 = (CanFestivalLibrary) Native.loadLibrary("canfestival", CanFestivalLibrary.class);
        //CanFestivalLibrary INSTANCE3 = (CanFestivalLibrary) Native.loadLibrary("canfestival_unix", CanFestivalLibrary.class);
      
        void printf(String format, Object... args);
        double cos(double x);
        int canClose_driver(String driver_name);
        String LoadCanDriver(String driver_name);
        void EnterMutex();
        void LeaveMutex();
        void heartbeatInit();
        void TimerInit();
        void StopTimerLoop();
    }


    // This is the standard, stable way of mapping, which supports extensive
    // customization and mapping of Java to native types.

    public static void main(String[] args) throws InterruptedException {
        CanFestivalLibrary.INSTANCE2.printf("Hello, World\n");
        System.out.println("RESULT de canClose_driver =" + CanFestivalLibrary.INSTANCE.canClose_driver("virtual"));
        //System.out.println("RESULT de LoadCanDriver =" + CanFestivalLibrary.INSTANCE3.LoadCanDriver("toto"));
        System.out.println("RESULT de TimerInit =");
        CanFestivalLibrary.INSTANCE2.TimerInit();
        Thread.sleep(100);
        System.out.println("RESULT de StopTimerLoop =");
        CanFestivalLibrary.INSTANCE2.StopTimerLoop();
        
        for (int i=0;i < args.length;i++) {
            CanFestivalLibrary.INSTANCE.printf("Argument %d: %s\n", i, args[i]);

        }
    }
    
}
