/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.CommandReply.CommandStatus;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.errors.HardwareErrorDetectedException;

/**
 *
 * @author virieux
 */
public class SftMainModule extends Module {

    private Filter dummyFilter;

    private SftCarouselModule carousel;
    private SftAutoChangerModule autochanger;
    private int limitMax = 15;

    @Override
    public void initModule() {

        carousel = (SftCarouselModule) this.getModule("carousel");       
	autochanger = (SftAutoChangerModule) this.getModule("autochanger");
        
    }

    private void locateFilters() {
                carousel.getSockets()[0].putFilterOnSocket(dummyFilter);
                carousel.engageClampsContact();
    }

    public String printFilters() {

	StringBuilder sb = new StringBuilder(getName() + " printFilters \n ");

        sb.append(dummyFilter.getName());
        sb.append(" position: ").append(this.carousel.getFilterPosition(dummyFilter));
	sb.append(" socket number: ").append(this.carousel.getSocketNumber(dummyFilter));
	sb.append(" standby position: ").append(this.carousel.getStandbyPositionForFilter(dummyFilter));


	log.info(sb.toString());
	return sb.toString();

    }

    @Override
    public String toString() {
            StringBuilder sb = new StringBuilder(getName());
            sb.append("\n").append(carousel.toString());
            sb.append("\n").append(autochanger.toString());
            return sb.toString();
    }

    public String displayData() {
            StringBuilder sb = new StringBuilder("Data published by ");
            sb.append(getContext().getSubsystem().getName()).append("\n  ");
            sb.append(CarouselModule.publishedByCarouselOutputName);
            sb.append(carousel.getStatusData().toString());
            sb.append("\n  ");
            sb.append(AutoChangerModule.publishedByAutoChangerOutputName);
            sb.append(autochanger.getStatusData().toString());
            return sb.toString();
     }

    /**
     * Initial state for sequence1 :
     * autochanger is in highposition and trucks are empty
     * carousel holds a filter and its clamps are in CLAMPEDONFILTER state.
     * @return
     */
    public String goToInitialStateForSequence1() {
        return null;
    }

    /**
     * This method is the main sequence of commands that we want to test on the Single Filter Test.
     * It executes this sequence of command a single time.
     * Is consists in from the initial position (autochanger trucks empty in the higher position) :
     * <UL> <LI> the autochanger trucks go down along the rails to standby position, 
     *      <LI> the autochanger grabbes the filter at standby position, 
     *      <LI> the carousel ungrabbes the filter at standby position,
     *      <LI> the autochanger moves the filter to the higher position,
     *      <LI> the carousel release the clamps to be ready to clamp a filter again,
     *      <LI> the autochanger moves back the filter at standby position,
     *      <LI> the carousel checks if the filter is clamped at standby position,
     *      <LI> the autochanger unlocks the filter latches,
     *      <LI> the autochanger trucks go empty to the higher position.
     * </UL>
     * @return a message for the operator
     * @throws BadCommandException
     * @throws ErrorInCommandExecutionException
     */
    public String executeSequence1() throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException {

        //autochanger trucks go to standby position to grabbe the filter held by carousel
	log.info("Autochanger trucks moving empty to standby position.");
        autochanger.grabbeFilterAtStandby(getDummyFilter());

        // carousel clamps are opened and go in the READYTOCLAMP state
        // when autochanger moves up the filter
        log.info("Carousel is ungrabbing filter at standby position.");
        carousel.ungrabbeFilterAtStandby(getDummyFilter());

        //autochanger trucks hold the filter are move it to Online Position
        log.info("Autochanger trucks moving loaded with the filter to standback position.");
        autochanger.moveFilterToStandback(dummyFilter);
        
        //log.debug("STATE of clamp X minus= " + carousel.getSocketAtStandby().getClampXminus().getState().toString());
        //log.debug("STATE of clamp X plus= " + carousel.getSocketAtStandby().getClampXplus().getState().toString());
        carousel.getSocketAtStandby().getClampXminus().updateStateWithSensors();
        //log.debug("STATE of clamp X minus= " + carousel.getSocketAtStandby().getClampXminus().getState().toString());
        carousel.getSocketAtStandby().getClampXplus().updateStateWithSensors();
        //log.debug("STATE of clamp X plus= " + carousel.getSocketAtStandby().getClampXplus().getState().toString());
    

        carousel.releaseClamps();

        //then we go back to the initial position :
        //autochanger move back the filter in standby position
        log.info("Autochanger trucks moving back the filter to standby position.");
        autochanger.moveFilterToStandby(dummyFilter);

        // carousel checks if the filter is clamped at standby position
        log.info("Carousel is grabbing filter at standby position.");
        carousel.grabbeFilterAtStandby(getDummyFilter());

        //then the autochanger can unclamp the filter and go to swapout position
        log.info("Autochanger moving back empty to online position.");
        autochanger.unGrabbeFilterAtStandby();

        return getName() + " Execution of Sequence1 completed";
    }
    
    /**
     * This method will execute nb times the Sequence1 : the parameter nb
     * is given by the user at the console.
     * @param nb : number of times we want to execute the Sequence1
     * @return 
     */
    public String executeSequence1(int nb) throws BadCommandException, ErrorInCommandExecutionException, HardwareErrorDetectedException {
        

        if ((nb < 1) || (nb > 20000)) throw new IllegalArgumentException("nb has to be comprise between 1 and 20000");
        
        for (int i=1; i < nb; i++) {
            
            log.info("Executing Sequence1 " + i + " times");
            executeSequence1(); 
        }
        return getName() + "Many Executions of Sequence1 completed";
    }

    boolean autochangerLatchesAreLocked() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    /**
     * @return the dummyFilter
     */
    public Filter getDummyFilter() {
        return dummyFilter;
    }

    /**
     * @param dummyFilter the dummyFilter to set
     */
    public void setDummyFilter(Filter dummyFilter) {
        this.dummyFilter = dummyFilter;
    }

    public Filter getFilterAtStandby() {
        return carousel.getFilterAtStandby();
    }
}
