/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.common.EngineState;
import org.lsst.ccs.subsystems.fcs.common.ModuleState;
import org.lsst.ccs.subsystems.fcs.common.Motor;

/**
 * This class is for the Single Filter Test autochanger.
 * The autochanger in Single Filter Test has no flip rail and
 * no online clamp.
 *
 * @author virieux
 */
public class SftAutoChangerModule extends BasicAutoChangerModule {
    private volatile ModuleState state = ModuleState.HALTED;
    Motor motor;
    
    

    private Filter getFilterAtStandbyOnCarousel() {
        return ((SftMainModule) this.getModule("main")).getFilterAtStandby();
    }
  
    public String toString() {
        return getName();
    }

 
    @Override
    public String goToPosition(double requiredPosition) throws IllegalArgumentException, BadCommandException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String stop() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
    public String goToStandby() {
        return null;
    }
    
    public String goToStandback() {
        return null;
    }

    @Override
    public String moveFilterToStandback(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException {
        if (isEmpty()) {
            throw new BadCommandException("Autochanger is empty");
        }
//        if (getTrucksPosition() == this.getTrucksPositionOnline()) {
//            throw new BadCommandException("Filter " + aFilter.getName() + " is already at online position.");
//        }

        goToStandback();
//        if (getTrucksPosition() == this.getTrucksPositionOnline()) {
//            log.info(getName() + ": " + aFilter.getName() + " is at online position");
//        }
        log.error("");
        return null;
    }

    @Override
    public String moveFilterToStandby(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException {
        if (isEmpty()) {
            throw new BadCommandException("Autochanger is empty");
        }
//        if (getTrucksPosition() == this.getTrucksPositionAtStandby()) {
//            throw new BadCommandException("Filter " + aFilter.getName() + " is already at standby position.");
//        }

        goToStandby();
//        if (getTrucksPosition() == this.getTrucksPositionAtStandby()) {
//            log.info(getName() + ": " + aFilter.getName() + " is at standby position.");
//            return getName() + ": " + aFilter.getName() + " is at standby position.";
//        } else {
//            String message = "the autochanger truck is not at the required position.";
//            log.error(message);
//            throw new ErrorInCommandExecutionException(message);
//        }
        return getName() + ": " + aFilter.getName() + " is at standby position.";
    }

    @Override
    public String moveFilterToOnline(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException {
        return moveFilterToStandback(aFilter);
    }

    public double getTrucksPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void locateTrucks() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Motor getMotor() {
        return motor;
    }

    public void setMotor(Motor motor) {
        this.motor = motor;
    }

    public boolean isMoving() {
        return this.motor.getEngineState().equals(EngineState.RUNNING);
    }


    
    
    
    



}
