/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.EngineState;
import org.lsst.ccs.subsystems.fcs.common.Motor;
import org.lsst.ccs.subsystems.fcs.common.RunningWay;

/**
 *
 * @author virieux
 */
public abstract class SimulatedMotor extends Module implements Motor {

    private String serialNumber;
    private double maximalVelocity;
    private double nominalVelocity;

    /**
     * duration of the last command go sent to the motor
     */
    private double period;
    private double position;

    /**
     * final position we want to go to
     */
    private double requiredPosition;



    private RunningWay runningWay;

    /**
    * lastcall is the time in milliseconds between 2 ticks
    * of the timer
    */
    private long lastcall;


    /**
     * time of the last state change (last command go)
     */
    private long stateChangeTime;

    private EngineState engineState;
    private String positionOutputName;
    private double maximalPosition;
    private double minimalPosition;

    /**
     * This constructor is here only for unit tests.
     * The actual values come from the xml config file for FCS
     * or it is initialized by the Module which uses this motor.
     */
    public SimulatedMotor() {
        this.lastcall = 0;
	this.period = 0;
	this.engineState = EngineState.STOP;
	this.stateChangeTime = 0;
	this.position = 0;	
	this.requiredPosition = 0;
        this.minimalPosition = 0;
        this.maximalPosition = 0;
    }

    @Override
    public synchronized EngineState getEngineState() {
        return this.engineState;
    }

    @Override
    public double getMaximalVelocity() {
        return this.maximalVelocity;
    }

    @Override
    public double getNominalVelocity() {
        return this.nominalVelocity;
    }

    @Override
    public double getPeriod() {
        return this.period;
    }

    @Override
    public double getPosition() {
        return this.position;
    }

    @Override
    public double getRequiredPosition() {
        // TODO Auto-generated method stub
        return this.requiredPosition;
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public long getStateChangeTime() {
        return this.stateChangeTime;
    }


    @Override
    public synchronized void setEngineState(EngineState engineState) {
        this.engineState = engineState;
    }

    @Override
    public void setMaximalVelocity(double maximalVelocity) {
        this.maximalVelocity = maximalVelocity;
    }

    @Override
    public void setNominalVelocity(double nominalVelocity) {
        this.nominalVelocity = nominalVelocity;
    }

    @Override
    public void setPeriod(double d) {
        this.period = d;
    }

    /**
     * @param position the position to set
     */
    public void setPosition(double position) {
        this.position = position;
    }

    @Override
    public void setRequiredPosition(double requiredPosition) {
        this.requiredPosition = requiredPosition;
    }

    @Override
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Override
    public void setStateChangeTime(long currentTimeMillis) {
        this.stateChangeTime = currentTimeMillis;
    }
    public double getMaximalPosition() {
        return this.maximalPosition;
    }

    public double getMinimalPosition() {
        return this.minimalPosition;
    }

    public void setMaximalPosition(double p) {
        this.maximalPosition = p;
    }

    public void setMinimalPosition(double p) {
        this.minimalPosition = p;
    }


    @Override
    public void stop() {
        engineState.stop(this);
    }

        @Override
    public void initModule() {
        try {
            log.info(" Initializing the Module : " + getName());
            //TODO the initial value for the position must be a parameter
            log.info(getName() + ": Initial position= " + getPosition());
        } catch (final RuntimeException e) {
            log.fatal(getName() + "in ERROR: " + " Initialization failed for simulated motor module : " + e.getMessage());
            throw e;
        }
    }

    @Override
    public void move(double displacement) {
        if (displacement > 0) {
            move(displacement, RunningWay.POSITIVE);
        } else {
            move(-displacement, RunningWay.NEGATIVE);
        }
    }

    /**
    * This method sends a command go to the simulated motor.
    * It computes the needed period for the displacement.
    * Displacement has to be positive.
    */
    public void move(double displacement, RunningWay theRunningWay) {
        if (displacement < 0) {
            throw new IllegalArgumentException(this.getName() + "/ displacement must be positive : " + displacement);
        }
        this.runningWay = theRunningWay;
        // we compute the time needed for the required displacement.
        final double periodNeededForThisDisplacement = (displacement / this.nominalVelocity) * 1000;
        log.info(getName() + " displacement: " + displacement + " way: " + theRunningWay + " period: " + periodNeededForThisDisplacement);
        // we start the simulated engine for the period we have just computed.
        engineState.go(this, periodNeededForThisDisplacement, theRunningWay);
    }

    /**
    * What has to be done for each tick of the timer.
    * We have to compute the time since the last tick
    * and incremente the position.
    */
    @Override
    public void tick() {
        try {
            final long currenttime = System.currentTimeMillis();
           // if (lastcall == 0) {
             //   lastcall = currenttime;
            //}
            this.lastcall = currenttime;
            incrementPosition(engineState.computeDisplacement(this, this.tickMillis, this.runningWay));
        } catch (final Exception e) {
            log.error(e);
        }
    }

    /**
     * To be overrided in each subclasses.
     * Increments the position of the mobil mechanical item which is moved by this simulated motor.
     * @param inc
     */
    @Override
    public void incrementPosition(final double inc) {
        
        if ((getPosition() + inc > this.maximalPosition) ||
	            (getPosition() + inc < this.minimalPosition))
            throw new UnsupportedOperationException(getName() + " : displacement " + inc +
	           " undoable for this simulated motor, it's going out of position range. ");
	                
	if (!(inc == 0)) {
                            
	                    this.setPosition(this.getPosition() + inc);
	                    log.info(getName() + ": position=" + getPosition());
	                    setChanged();
	                    notifyObservers(new ValueUpdate(positionOutputName, this.getPosition()));
	}                
    }



}
