/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import java.math.BigDecimal;
import java.util.Random;
import org.lsst.ccs.subsystems.fcs.common.Sensor12bits;


/**
 * This class is to simulate a sensor which returns a value coded on 12bits.
 * It returns a random value between value1 and value2.
 * 
 * @author virieux
 */
public class SimuSensor12bits extends Sensor12bits {

    int value1;
    int value2;
    Random randomGenerator = new Random();;
    
    //Default constructeur for Spring 
    public SimuSensor12bits() {}
    
    /**
     * Constructeur for a simulated sensor
     * TODO: the values cannot be greater than maxValue
     * @param aValue1
     * @param aValue2 
     */
    SimuSensor12bits(int aValue1, int aValue2) {
        super();
        this.value1 = aValue1;
        this.value2 = aValue2;
    }
    
    
    void setNewRange(int aValue1, int aValue2) {
        if ((aValue2 < aValue1) || (aValue2 > getMaxValue())) {
            throw new IllegalArgumentException("we must have : value1 < value2 < maxValue");
        }
        this.value1 = aValue1;
        this.value2 = aValue2;
    }

    /**
     * 
     * @return a random between value1 and value2
     */
    public int readNewValue() {
        //System.out.println("value1= " + value1 + " value2= " + value2);
        int n = randomGenerator.nextInt(value2);  
        if (n > value1) {
            return n;
        } else {
            BigDecimal bd = new BigDecimal(value1 + n * (value2 - value1)/value2);           
            return bd.intValue();
        }
    }


}
