/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Observable;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.common.FilterClampState;

/**
 * A very basic simulated filter clamp module.
 * It has no sensor to know if the clamp is locked or not.
 * This clamp is locked when the clamps actuator of the carousel are off.
 * And its filter presence sensor is configured to returns the value we expect!
 * 
 * @author virieux
 */
public abstract class SimuFilterClampModule extends FilterClampModule {

    /*
     * AutoChanger trucks position limit to know if a filter is
     * on carousel or not.
     */
    private double trucksPositionLimit;

    private boolean atStandby;
    
    public CarouselModule carousel;
    
    //TODO just for tests (cf tick method). 
    private BasicAutoChangerModule autochanger;



    public abstract boolean isLocked();
  


    @Override
    public void initModule() {
        this.carousel = (CarouselModule) this.getModule("carousel");
        this.autochanger = (BasicAutoChangerModule) this.getModule("autochanger");
        initPublishedData();
        state = FilterClampState.CLAMPEDONFILTER;
        ((SimuSensor12bits) getFilterPresenceSensor()).setNewRange(getValueA(), getValueB());
        trucksPositionLimit = 5;
        setAtStandby(false);
    }

    /**
    * What to do when the Modules we observe send there new values.
    * A Simulated clamp Module observes the autochanger.
     * When the trucks are under a limit, we considere that the filter is at
     * standby position, so the simulated presence filter sensor has to be 
     * configured to returns a value in the range of 
     * 
    *
    *
    */
//    @Override
//    public void processUpdate(Observable source, ValueUpdate v) {
//
//          //The state of the simulated clamp changes with the autochanger trucks position.
//          //But it changes only if the clamp is at standby position.
//
//          if (this.isAtStandby() && v.getName().equals(AutoChangerModule.publishedByAutoChangerOutputName))  {
//               StatusDataPublishedByBasicAutoChanger data = (StatusDataPublishedByBasicAutoChanger) v.getValue();
//               
//               //if autochanger trucks are loaded and position is > trucksPositionLimit
//               //filter presence sensor should return a value between C and maxValue
//               log.debug("IN SIMULATED CLAMP data.getTrucksPosition()=" + data.getTrucksPosition());
//               if ( !data.isEmpty()  &&  (data.getTrucksPosition() > trucksPositionLimit)) {
//                   ((SimuSensor12bits) getFilterPresenceSensor()).setNewRange(getValueC(), ((SimuSensor12bits) getFilterPresenceSensor()).getMaxValue());
//               } else {                  
//                   ((SimuSensor12bits) getFilterPresenceSensor()).setNewRange(getValueA(), getValueB());
//               }
//
//          this.publishedByClamp.update(this);
//          setChanged();
//          notifyObservers(new ValueUpdate(publishedByClampOutputName, this.publishedByClamp));
//          }
//
//
//
//    }
    
    //TODO this is added just for tests because processUpdate doesn't work anymore. (03/05/2012)
    //This should be modified or deleted or it should replace processUpdate.
    @Override
    public synchronized void tick() {
        if (!autochanger.isEmpty() && autochanger.getTrucksPosition() > this.trucksPositionLimit) {
            ((SimuSensor12bits) getFilterPresenceSensor()).setNewRange(getValueC(), ((SimuSensor12bits) getFilterPresenceSensor()).getMaxValue());
        } else {
            ((SimuSensor12bits) getFilterPresenceSensor()).setNewRange(getValueA(), getValueB());
        }
       updateStateWithSensors();
       log.debug(getName() + " : filterPresence =" + filterPresence.toString());
       this.publishedByClamp.update(this);
       setChanged();
       notifyObservers(new ValueUpdate(publishedByClampOutputName,this.publishedByClamp));
    }
    

    /**
     * @return the atStandby
     */
    public boolean isAtStandby() {
        return atStandby;
    }

    /**
     * @param atStandby the atStandby to set
     */
    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }
}
