package org.lsst.ccs.subsystems.fcs.simulation;

import org.apache.log4j.Logger;
import org.lsst.ccs.subsystems.fcs.common.Motor;
import org.lsst.ccs.subsystems.fcs.common.EngineState;
import org.lsst.ccs.subsystems.fcs.common.RunningWay;

/**
 * This is the concrete state where we know what to be done when the engine is
 * in the state "running".
 * 
 * @author colley, virieux
 * 
 */
public class RunningState implements EngineState {
	
	protected static Logger log = Logger.getLogger("lsst.ccs.fcs.simulation");

	@Override
	public String toString() {
		return "running";
	}

	/**
	 * Computes the displacement (rotation angle or position) for this engine state during a time period.
	 * It can be positive or negative according to the running way. 
	 * @param motor
	 * @param period 
	 * @param runninWay 
	 */
	public double computeDisplacement(Motor motor, double period,
			RunningWay runningWay) {
		
		double displacement = 0;
		//System.out.println("[RunningState] period= " + period);
		double diff = System.currentTimeMillis() - motor.getStateChangeTime();
	
		
		if (diff < motor.getPeriod()) {
                        displacement = (motor.getNominalVelocity() * period) / 1000;
			if (runningWay == RunningWay.POSITIVE) {
				displacement = (motor.getNominalVelocity() * period) / 1000;
			} else if (runningWay == RunningWay.NEGATIVE) {
				displacement = -((motor.getNominalVelocity() * period) / 1000 );
			} else throw new IllegalArgumentException(" [RunningState] ERROR : wrong running way.");
			
			return displacement;
                //we are arrived at this end of the period, we have to stop the simulated motor
		} else {
			//because period is not every time a multiple of the tick time,
			//we need to rotate a little more to be at the required position.
			motor.stop();
			displacement = motor.getRequiredPosition() - motor.getPosition();
                        return displacement;
                        
		}
	}

	public String error(Motor motor) {
		motor.setStateChangeTime(System.currentTimeMillis());
		motor.setEngineState(ERROR);		
		return "ERROR";
	}

	/**
	 * Engine stays in state running when it is running and it receives the command go.
	 */
	
	public String go(Motor motor, double t, RunningWay runningWay) {	
		return null;
	}

	/**
	 * It goes to "stop" when asked.
	 */
	
	public String stop(Motor motor) {
		motor.setStateChangeTime(System.currentTimeMillis());
		motor.setEngineState(STOP);
		String message = motor.getName() + " [RunningState] motor stopped";
		log.info(message);
		return message;
	}

}
