
/**
 * This package is for the control software of the LSST camera Filter Exchanger Subsystem.
 * It contains many subpackages for the test stands, for the GUI, for commons stuff, 
 * for simulation classes or for real drivers classes.
 * The control softwares for the test stands could probably go in another place, because they will
 * be used only during the construction of the camera.
 * Here are the test stands we have :
 * <UL>
 *  <LI>singlefiltertest: The test for the clamps.</LI> 
 *  <LI>testbench: a small test stand in APC to test the communication with the can open drivers.</LI>
 * </UL>
 * 
 * The FCS is a Modular Subsystem, a set of Modules that listens each other. This Modules are assembled within an xml file.
 * The 4 most important Modules are :
 * <UL>
 *  <LI>AutoChangerModule: The main Module for the control of the autochanger.</LI>
 *  <LI>CarouselModule: The main Module for the control of the carousel.</LI>
 *  <LI>LoaderModule: The main Module for the control of the loader.</LI>
 *  <LI>FcsMainModule: The main Module for the control of the fcs viewed as a whole subsystem.</LI>
 * </UL>
 * 
 * For each piece of hardware that moves or can be controled, there is a Module and an interface in the 
 * subpackage <tt>common</tt>. The Module implements the interface. 
 * We can have the sofware for the simulator when we build the fcs with the hardware simulated classes 
 * in the package <tt>simulation</tt> or we can have the control software for the hardware 
 * when we build the fcs with the drivers classes in the package <tt>drivers</tt>.
 * 
 * 
 */
package org.lsst.ccs.subsystems.fcs;
