/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.common.Sensor12bits;

/**
 * This is a Model for a sensor on a can open bus which communicates over Can Open protocol.
 * The sensor is supposed to be connected to a ADC with analogics input.
 * It will probably move to the package org.lsst.ccs.drivers.canopen
 * @author virieux
 */
public class CanOpenSensor12bits extends Sensor12bits {
    
    CanOpenProxy carouselProxy;

    /*
     * Node ID : the Can Open node ID of the ADC.
     */
    int nodeID;
    
    /*
     * The identifier number of the input on the ADC.
     */
    int inputID;
    
    /*
     * The identifier number of the input on the ADC.
     */
    int index;
    
    /*
     * The identifier number of the input on the ADC.
     */
    int subindex;
    
    /*
     * The value read on the input of the ADC.
     */
    int value;
    
    public CanOpenSensor12bits(int aNodeID) {
        this.value=0;
        this.nodeID = aNodeID;
               
    } 
    
    public int getNodeID() {
        return nodeID;
    }

    public void initModule() {
        carouselProxy = (CanOpenProxy) this.getModule("carouselProxy");
    }

    public int readNewValue() {
        return carouselProxy.readADC(nodeID,inputID,index,subindex);
    }



}
