/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.errors.BootingHardwareError;
import org.lsst.ccs.subsystems.fcs.errors.ReadingADCError;

/**
 *
 * @author virieux
 */
public class CanOpenProxy extends Module {
    
    private ApcTcpProxy tcpProxy;
    /*This is the key word that has to be sent by the client when it connects to the tcp proxy. */
    private String myClientName = "CanOpenProxy";
    /*number of can open nodes expected on the device */
    private int nodeNB = 2;
    /*number of booted nodes*/
    private int bootednodeNB = 0;
    /*number of received command with "info"*/
    private int infoNB = 0;
    /*An array of booted hardware*/
    private CanOpenNode[] nodes = new CanOpenNode[nodeNB];
    private boolean hardwareBooted = false;
    private boolean adcInitialized = false;
    
        /**
     * @return the myTcpProxy
     */
    public ApcTcpProxy getTcpProxy() {
        return tcpProxy;
    }

    /**
     * @param myTcpProxy the myTcpProxy to set
     */
    public void setTcpProxy(ApcTcpProxy myTcpProxy) {
        this.tcpProxy = myTcpProxy;
    }

    /**
     * @return the myClientName
     */
    public String getMyClientName() {
        return myClientName;
    }

    /**
     * @param myClientName the myClientName to set
     */
    public void setMyClientName(String myClientName) {
        this.myClientName = myClientName;
    }
    
    @Override
    public void initModule() {
       nodes = new CanOpenNode[nodeNB];
    }
    
    @Override
    public void tick() {
        //INITIALISATION 
        //first we want to check the hardware is booted.
        if (!hardwareBooted && tcpProxy.isReady(myClientName)) {
            try {
                bootHardware();
            } catch (BootingHardwareError ex) {
                Logger.getLogger(CanOpenProxy.class.getName()).log(Level.SEVERE, null, ex);
            } 
        }
        
        /*Initialisation of the ADCs : transmission type*/
        if (hardwareBooted && !adcInitialized) {
            try {
                    //TODO to ganeralize : replace with a boucle on the table of nodes.
                    initADC(1,1);
                    adcInitialized = true;
                    log.debug("ADC is initialized");
                } catch (ReadingADCError ex) {
                    Logger.getLogger(CanOpenProxy.class.getName()).log(Level.SEVERE, null, ex);
                } catch (HardwareNotBootedError ex) {
                    Logger.getLogger(CanOpenProxy.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
    }
    

    
     /**
     * This method listens to the tcp socket and waits for the reading of 
     * a "boot" line and a "info" line for each can open nodes.
     * Then it creates an array (nodes) with all the booted nodes.
     */
    private void bootHardware() throws BootingHardwareError {
       
       //TODO there must be a timeout.
       while (this.bootednodeNB < this.nodeNB || this.infoNB < this.nodeNB) {
                String bootLine = tcpProxy.readFromSocket(myClientName);
                String[] words = bootLine.split(",");
                String command = words[0];
                int nodeID = Integer.parseInt(words[1]);
                log.debug("Received on socket command = " + command + "," + nodeID);
                if (command.equals("boot")) {                      
                    nodes[bootednodeNB] = new CanOpenNode(nodeID); 
                    bootednodeNB++;
                    log.debug("Node " + nodeID + " added");
                    log.debug("Hardware booted nb=" + bootednodeNB);
                } else if (command.equals("info")) {
                    int type = Integer.parseInt(words[2]);
                    int vendor = Integer.parseInt(words[3]);
                    int productCode = Integer.parseInt(words[4]);
                    int revision = Integer.parseInt(words[5]);
                    addNodeInfo(nodeID,type,vendor,productCode,revision);
                    this.infoNB++;
                    log.debug("Node Info" + nodeID + " added");
                } //TODO what if we receive a command which is no "boot" neither "info" before the end
                  //of the booting process ?                            
            }
       if (bootednodeNB == nodeNB && infoNB == nodeNB) {
           hardwareBooted = true;
       } else throw new BootingHardwareError(myClientName);
      
    }


    private void addNodeInfo(int nodeID, int type, int vendor, int productCode, int revision) throws BootingHardwareError  {
        
        boolean nodeFound = false;
        for (int i=0; i < nodes.length; i++ ) {
            if (!(nodes[i] == null) &&  (nodes[i].getNodeID() == nodeID)) {
                nodes[i].setNodeInfo(type, vendor, productCode, revision);
                nodeFound = true;
            }
        }
        if (!nodeFound) throw new BootingHardwareError(myClientName, nodeID);       
    }

    /**
     * List the can open nodes which are booted.
     * It means that we have received  a "boot,nodeID" and a "info,nodeID" messages
     * for these nodes.
     * @return the list of can open nodes and the information stored in this.nodes.
     */
    public String listNodes() {
        
        StringBuilder sb = new StringBuilder("Nodes LIST = ");
        for (int i=0; i < nodes.length; i++) {
            sb.append("\n");
            sb.append(nodes[i].toString()) ;
        }
        log.debug(sb.toString());
        return sb.toString();
    }
    
     /**
     * Initialize the ADC at nodeID and configure the way it will send its data : 
     * we want it to send data each time it receives syncNB SYNC.
     * if syncNB = 1, it will send data every SYNC,
     * if syncNB = 2, it will send data every 2 SYNC, etc...
     * @param syncNB 
     */
    private void initADC(int nodeID, int syncNB) throws ReadingADCError, HardwareNotBootedError {
        if (!hardwareBooted) throw new HardwareNotBootedError();
        //for the first 4 INPUT channels from 1 to 4
        String canOpenCommand1 = buildCanOpenCommand("wsdo",nodeID,1801,2,1,1);
        Object ack = getTcpProxy().call(getMyClientName(), canOpenCommand1);
        if (ack instanceof String) {           
                log.debug("initADC-step1 = " + ack); 
                //for the last 4 INPUT channels from 5 to 8
                String canOpenCommand2 = buildCanOpenCommand("wsdo",nodeID,1802,2,1,1);
                Object ack2 = getTcpProxy().call(getMyClientName(), canOpenCommand2);
                log.debug("initADC-step2 = " + ack2); 
        } else throw new ReadingADCError(ack);
        
    }
    
    /**
     * For engineering mode, this method can be used to send Can Open commands
     * to the Wrapper. 
     * Not very useful as we can send the same command from the console with:
     * invoke apctestbench/tcpProxy call APCTestBench command
     * @param command A Can Open command that the Wrapper should understand.
     * @return the response from the Wrapper
     */
    private Object sendCanOpen(String command) {
        return getTcpProxy().call(getMyClientName(), command);
    }
    
    public void stop() {
        this.getTcpProxy().stop();
    }
    
    /*build a Can Open Command that can understand the C wrapper.*/
    private static String buildCanOpenCommand(String command, int nodeID, int index, int subindex, int size, int data) {
        StringBuilder sb = new StringBuilder(command);
        String sep = ",";
        sb.append(sep); sb.append(nodeID);
        sb.append(sep); sb.append(index);
        sb.append(sep); sb.append(subindex);
        sb.append(sep); sb.append(size);
        sb.append(sep); sb.append(data);
        return sb.toString();
    }

    int readADC(int nodeID, int inputID, int index, int subindex) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    int writeDAC(int nodeID, int inputID, int index, int subindex, int value) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
    
    



    
}
