/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

/**
 * 
 * @author virieux
 */
public class CanOpenNode {

    private int nodeID;
    private int type;
    private int vendorID;
    private int productCode;
    private int revision;
    
    public CanOpenNode(int id) {
        //TODO
        //id can't be > 127
        nodeID = id;
        type = 0;
        vendorID = 0;
        productCode = 0;
        revision = 0;
    }

    /**
     * @return the nodeID
     */
    public int getNodeID() {
        return nodeID;
    }

    /**
     * @return the type
     */
    public int getType() {
        return type;
    }

    /**
     * @return the vendorID
     */
    public int getVendorID() {
        return vendorID;
    }

    /**
     * @return the productCode
     */
    public int getProductCode() {
        return productCode;
    }

    /**
     * @return the revision
     */
    public int getRevision() {
        return revision;
    }
    
    public void setNodeInfo(int type, int vendor, int code, int revision) {
        this.type = type;
        this.vendorID = vendor;
        this.productCode = code;
        this.revision = revision;
        
    }
    
    /*Says if a Can Open node is an ADC or not*/
    /*This method is adapted to the CAN-CBX-AI814; it could change.*/
    public boolean isADC() {
        return (type == 40191);
    }
    
    /*Says if a Can Open node is a DAC or not*/
    /*This method is adapted to the CAN-CBX-AO412; it could change.*/
    public boolean isDAC() {
        return (type == 80191);
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Node ID= ");
        sb.append(getNodeID());
        sb.append("/ type=");sb.append(getType());
        sb.append("/ vendor=");sb.append(getVendorID());
        sb.append("/ product code=");sb.append(getProductCode());
        sb.append("/ revision=");sb.append(getRevision());
        return sb.toString();
    }
    
    
    
    
}
