package org.lsst.ccs.subsystems.fcs.drivers;

import org.apache.log4j.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.utilities.beanutils.WrappedException ;
import org.lsst.ccs.utilities.dispatch.ASyncObserver;
import org.lsst.ccs.utilities.dispatch.ParallelObservable;

import java.io.*;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.subsystem.proxies.HardwareControlNotReady;

/**
 *
 * @author virieux
 */
public class ApcTcpProxy extends Module {
    private static Logger logger = Logger.getLogger("lsst.ccs.subsystem");
    private int portNumber = 50000;
    private Subsystem subsystem;
    private ServerSocket serverSock;
    private Thread serverThread;
    private volatile boolean stopped ;
    
        /**
     * this class is going to changed.
     * each ClientContext will have an Object implementing the PayloadHandler interface
     * <PRE>
     *     interface PayloadHandler {
     *        void toBytes(ByteBuffer buffer) ;
     *        void fromBytes(ByteBuffer buffer) ;
     *     }
     * </PRE>
     * (these based on ByteBuffer with gatheringbytebuffer)
     * <P>
     *     the protocol will be that the client send a name and the name of a Protocol
     *     so for instance if protocole is "smurfCard"
     *     the corresponding class will be somepackage.ProtocolSmurfCard
     *     that will implement PayloadHandler
     * </P>
     *
     */
    protected class ClientContext {
        String clientName;
        BufferedReader reader;
        BufferedWriter writer;
        int token ;

        ClientContext(String name, BufferedReader reader, OutputStream os) {
            try {
                this.reader = reader;
                writer = new BufferedWriter(new OutputStreamWriter(os, "ISO-8859-1"), 256);
            } catch (UnsupportedEncodingException e) {
                /*. SHOULD NOT HAPPEN */
                logger.error("context not started", e);
                throw new Error(e);
            }
        }
    }

    private  ConcurrentHashMap<String, ClientContext> map = new ConcurrentHashMap<String, ClientContext>();

    private ParallelObservable<ClientContext> observable = new ParallelObservable<ClientContext>() ;
    
    protected ClientContext getContextFor(String clientName) {
        return map.get(clientName) ;
    }

    public void addObserver(ASyncObserver<ClientContext> observer) {
        observable.addObserver(observer);
    }

    public void removeObserver(ASyncObserver<ClientContext> observer) {
        observable.removeObserver(observer);
    }


    @Override
    public void initModule() {
        try {
            serverSock = new ServerSocket(portNumber);
            logger.trace("SERVER STARTED :" + portNumber);
        } catch (IOException e) {
            logger.error("server not started",  e);
             throw new WrappedException(e) ;
        }
        Runnable runnable = new Runnable() {
            @Override
            public void run() {
                while (!stopped) {
                    try {
                        Socket sock = serverSock.accept();
                        logger.trace("accept on " + portNumber);
                        BufferedReader reader = new BufferedReader(
                                new InputStreamReader(sock.getInputStream(), "ISO-8859-1"), 256);
                        String nameAndProtocol = reader.readLine();
                        String[] words = nameAndProtocol.split(" ") ;
                        String name = words[0] ;
                        ClientContext context = new ClientContext(name, reader, sock.getOutputStream());
                        map.put(name, context);
                        observable.notifyObservers(context);
                        logger.trace("REGISTERED : " + name);
                    } catch (IOException e) {
                        // LOG
                        logger.warn(" unexpected " + e);
                        if(!stopped) {
                            //TODO 
                        logger.error("server in TcpProxy module : ", e);
                        }
                    }
                }
            }

        } ;
        serverThread = new Thread(runnable) ;
        serverThread.start() ;

    }
    
    public void stop() {
        stopped = true ;
        serverThread.interrupt();
        Enumeration<ClientContext> enumeration = map.elements();
        while(enumeration.hasMoreElements()) {
            ClientContext context = enumeration.nextElement();
            try {
                // should close socket instead
                context.reader.close();
                context.writer.close();

            } catch (Exception exc) {
               // FORGET IT
                System.out.println("todo: ");
            }
        }
        try{
            Thread.currentThread().interrupt();
            this.getSubsystem().shutdown();
        } catch (Exception exc) {
            logger.error("todo: change this!!!" + exc);
        }
        Thread.currentThread().interrupt();
        // TODO: change that!
        System.exit(0);
    }
    
    public boolean isReady(String clientName) {
        return null != map.get(clientName) ;
    }
    
    public Object call(String clientName, String command) {
        ClientContext context = map.get(clientName) ;
        logger.trace(" CALL :" + clientName + " " +command);
        if(context == null) {
            //return State.Oflline ;
            throw new HardwareControlNotReady(clientName);
        }
        if(stopped) {
            throw new IllegalStateException("textTCP module stopped") ;
        }
        try {
            //TODO: add token in front
            command = command +"\r\n" ;
            context.writer.write(command,0,command.length());
            context.writer.flush() ;
            String response = context.reader.readLine() ;
            logger.trace("received response : " + response);
            return response ;
        } catch (Exception e) {
            map.remove(clientName) ;
            throw new WrappedException( " --> removed " + clientName, e);
        }
    }
    
    public String readFromSocket(String clientName) {
        ClientContext context = map.get(clientName) ;
        logger.trace(" READ :" + clientName + " ");
        if(context == null) {
            //return State.Oflline ;
            throw new HardwareControlNotReady(clientName);
        }
        if(stopped) {
            throw new IllegalStateException("textTCP module stopped") ;
        }
        try {
            String response = context.reader.readLine() ;
            logger.trace("read from Socket : " + response);
            return response ;
        } catch (Exception e) {
            map.remove(clientName) ;
            throw new WrappedException( " --> removed " + clientName, e);
        }
        
    }



    public int getPortNumber() {
        return portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }
    
    
}
