/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.subsystems.fcs.errors.SensorValueOutOfRangeException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.framework.Module;

/**
 * This class represents a 12bits sensor : the value returned by the sensor is 
 * coded with 12 bits, so its value is between 0 and 4095.
 * @author virieux
 */
public abstract class Sensor12bits extends Module implements Sensor {
    
    
   String name;
   int value;   
   int minValue = 0;
   private int maxValue = 4095;
   
//   //constrcuteur pour String 
//   public Sensor12bits() {}

 //Constructeur if we don't have Spring.
   public Sensor12bits() {
       this.value = 0;
       this.minValue = 0;
       this.maxValue = 4095;          
   }
   

   public int getValue() {
       return value;
   }
   
   //for Spring
   public void setValue(int aValue) {
       this.value = aValue;
   }

    /**
     * @return the maxValue
     */
    public int getMaxValue() {
        return maxValue;
    }
       
   /**
   * This method updates the sensor value : first it reads a new value from the 
     * hardware or from the simulated sensor,
     * then it checks if the value is in the range between minimal value and 
     * maximal value. If it's ok it updates the sensor value with the new value, 
     * otherwise it throws an exception.
   * 
   */
   public synchronized void updateValue() {
       //System.out.println("minValue: " + minValue + " maxValue: "+ maxValue);
       int newValue = readNewValue();
       //System.out.println("currentValue: " + newValue);
       if ((newValue < minValue) || (newValue > maxValue)) {
        try {
            throw new SensorValueOutOfRangeException(this, newValue);
        } catch (SensorValueOutOfRangeException ex) {
            Logger.getLogger(Sensor12bits.class.getName()).log(Level.SEVERE, null, ex);
        }
       }
       this.value = newValue;
   }

    @Override
    public String toString() {
        return Integer.toString(value);
    }

    
                 
}
